/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop.log;

import genepi.hadoop.HdfsUtil;
import genepi.hadoop.log.LogCollector;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Mapper;

public class Log {
    private Mapper.Context context;
    private String filename;
    private FSDataOutputStream out;

    public Log(Mapper.Context context) {
        this.context = context;
        this.filename = HdfsUtil.path(LogCollector.LOG_DIRECTORY, context.getJobID().toString(), context.getTaskAttemptID().toString());
        Configuration conf = HdfsUtil.getConfiguration();
        try {
            FileSystem fileSystem = FileSystem.get((Configuration)conf);
            this.out = fileSystem.create(new Path(this.filename));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void writeLine(String message) {
        String line = "[" + this.context.getTaskAttemptID() + "] " + message + "\n";
        try {
            this.out.write(line.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop(String message, Exception e) throws InterruptedException {
        this.writeLine("ERROR  " + message + "\n" + e);
        throw new InterruptedException(message);
    }

    public void stop(String message, String details) throws InterruptedException {
        this.writeLine("ERROR  " + message + "\n" + details);
        throw new InterruptedException(message);
    }

    public void error(String message, Exception e) {
        this.writeLine("ERROR  " + message + "\n" + e);
    }

    public void error(String message, String details) {
        this.writeLine("ERROR  " + message + "\n" + details);
    }

    public void info(String message) {
        this.writeLine("INFO  " + message);
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

