/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop.io;

import genepi.hadoop.HdfsUtil;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsLineWriter {
    private FSDataOutputStream out;
    private boolean first = true;

    public HdfsLineWriter(String filename) throws IOException {
        Configuration configuration = HdfsUtil.getConfiguration();
        FileSystem filesystem = FileSystem.get((Configuration)configuration);
        this.out = filesystem.create(new Path(filename));
    }

    public void write(String line) throws IOException {
        if (this.first) {
            this.out.writeBytes(line);
            this.first = false;
        } else {
            this.out.writeBytes("\n" + line);
        }
    }

    public void close() throws IOException {
        this.out.close();
    }
}

