/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop.importer;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import genepi.hadoop.HdfsUtil;
import genepi.hadoop.importer.FileItem;
import genepi.hadoop.importer.IImporter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;

public class HdfsImporterSftp
implements IImporter {
    private String server;
    private String workingDir;
    private String username = "anonymous";
    private String password = "anonymous@domain.com";
    private String path;
    private int port;
    private CountingOutputStream t;
    private String error;

    public HdfsImporterSftp(String url, String path) {
        this.server = url.split(";")[0];
        if (url.split(";").length > 1) {
            this.username = url.split(";")[1].trim();
        }
        if (url.split(";").length > 2) {
            this.password = url.split(";")[2];
        }
        this.path = path;
        this.port = 22;
        String server1 = this.server.replace("sftp://", "");
        String[] split = server1.split("/", 2);
        this.server = split[0].trim();
        this.workingDir = split.length > 1 ? "/" + split[1].trim() : "/";
    }

    @Override
    public boolean importFiles() {
        return this.importFiles(null);
    }

    @Override
    public boolean importFiles(String extension) {
        try {
            FileSystem fileSystem = HdfsUtil.getFileSystem();
            return this.importIntoHdfs(this.server, this.workingDir, this.username, this.password, fileSystem, this.path, this.port, extension);
        }
        catch (Exception e) {
            this.error = e.getMessage();
            e.printStackTrace();
            return false;
        }
    }

    private boolean importIntoHdfs(String server, String workingDir, String username, String password, FileSystem fileSystem, String path, int port, String extension) throws IOException, JSchException, SftpException {
        Session session = null;
        Channel channel = null;
        ChannelSftp channelSftp = null;
        JSch jsch = new JSch();
        try {
            try {
                session = jsch.getSession(username, server, port);
                session.setPassword(password);
                Properties config = new Properties();
                config.put("StrictHostKeyChecking", "no");
                session.setConfig(config);
                session.connect();
                channel = session.openChannel("sftp");
                channel.connect();
                channelSftp = (ChannelSftp)channel;
                Vector filelist = null;
                if (channelSftp.lstat(workingDir).isDir()) {
                    filelist = channelSftp.ls(workingDir);
                } else {
                    String filename = workingDir;
                    String[] tiles = workingDir.split("/");
                    workingDir = "";
                    int i = 0;
                    while (i < tiles.length - 1) {
                        workingDir = String.valueOf(workingDir) + tiles[i];
                        if (i < tiles.length - 2) {
                            workingDir = String.valueOf(workingDir) + "/";
                        }
                        ++i;
                    }
                    channelSftp.cd(workingDir);
                    filelist = channelSftp.ls(filename);
                }
                for (ChannelSftp.LsEntry entry : filelist) {
                    boolean linkIsdir = false;
                    if (entry.getAttrs().isLink()) {
                        String link = null;
                        link = channelSftp.readlink(entry.getFilename());
                        linkIsdir = channelSftp.lstat(link).isDir();
                    }
                    if (linkIsdir || entry.getAttrs().isDir() || entry.getFilename().equals(".") || entry.getFilename().equals("..")) continue;
                    boolean needImport = false;
                    if (extension == null) {
                        needImport = true;
                    }
                    if (!needImport) {
                        String[] exts;
                        String[] stringArray = exts = extension.split("|");
                        int n = exts.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String ext = stringArray[n2];
                            if (!needImport && entry.getFilename().endsWith(ext)) {
                                needImport = true;
                            }
                            ++n2;
                        }
                    }
                    if (!needImport) continue;
                    String[] tiles = entry.getFilename().split("/");
                    String name = tiles[tiles.length - 1];
                    String target = HdfsUtil.path(path, name);
                    FSDataOutputStream out = fileSystem.create(new Path(target));
                    this.t = new CountingOutputStream((OutputStream)out);
                    channelSftp.get(String.valueOf(workingDir) + "/" + entry.getFilename(), (OutputStream)this.t);
                    IOUtils.closeStream((Closeable)out);
                }
                channelSftp.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error = e.getMessage();
                session.disconnect();
                return false;
            }
        }
        finally {
            session.disconnect();
        }
        return true;
    }

    @Override
    public List<FileItem> getFiles() {
        Vector<FileItem> results = new Vector<FileItem>();
        Session session = null;
        Channel channel = null;
        ChannelSftp channelSftp = null;
        JSch jsch = new JSch();
        try {
            try {
                session = jsch.getSession(this.username, this.server, this.port);
                session.setPassword(this.password);
                Properties config = new Properties();
                config.put("StrictHostKeyChecking", "no");
                session.setConfig(config);
                session.connect();
                channel = session.openChannel("sftp");
                channel.connect();
                channelSftp = (ChannelSftp)channel;
                Vector filelist = null;
                if (channelSftp.lstat(this.workingDir).isDir()) {
                    filelist = channelSftp.ls(this.workingDir);
                } else {
                    String filename = this.workingDir;
                    String[] tiles = this.workingDir.split("/");
                    this.workingDir = "";
                    int i = 0;
                    while (i < tiles.length - 1) {
                        this.workingDir = String.valueOf(this.workingDir) + tiles[i];
                        if (i < tiles.length - 2) {
                            this.workingDir = String.valueOf(this.workingDir) + "/";
                        }
                        ++i;
                    }
                    channelSftp.cd(this.workingDir);
                    filelist = channelSftp.ls(filename);
                }
                for (ChannelSftp.LsEntry entry : filelist) {
                    boolean linkIsdir = false;
                    if (entry.getAttrs().isLink()) {
                        String link = null;
                        link = channelSftp.readlink(entry.getFilename());
                        linkIsdir = channelSftp.lstat(link).isDir();
                    }
                    if (linkIsdir || entry.getAttrs().isDir() || entry.getFilename().equals(".") || entry.getFilename().equals("..")) continue;
                    String[] tiles = entry.getFilename().split("/");
                    String name = tiles[tiles.length - 1];
                    FileItem item = new FileItem();
                    item.setText(entry.getFilename());
                    item.setPath("/");
                    item.setId("/");
                    item.setSize(FileUtils.byteCountToDisplaySize(entry.getAttrs().getSize()));
                    results.add(item);
                }
                channelSftp.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error = e.getMessage();
                session.disconnect();
                return null;
            }
        }
        finally {
            session.disconnect();
        }
        return results;
    }

    @Override
    public String getErrorMessage() {
        return this.error;
    }
}

