/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop.importer;

import genepi.hadoop.HdfsUtil;
import genepi.hadoop.importer.FileItem;
import genepi.hadoop.importer.IImporter;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;

public class HdfsImporterHttp
implements IImporter {
    private String url;
    private String path;
    private CountingOutputStream t;
    private String error;

    public HdfsImporterHttp(String url, String path) {
        this.url = url.split(";")[0];
        this.path = path;
    }

    public long getFileSize() {
        try {
            URL webUrl = new URL(this.url);
            HttpURLConnection conn = (HttpURLConnection)webUrl.openConnection();
            return conn.getContentLength();
        }
        catch (MalformedURLException e) {
            this.error = e.getMessage();
            return -1L;
        }
        catch (IOException e) {
            this.error = e.getMessage();
            return -1L;
        }
    }

    @Override
    public boolean importFiles() {
        return this.importFiles(null);
    }

    @Override
    public boolean importFiles(String extension) {
        try {
            FileSystem fileSystem = HdfsUtil.getFileSystem();
            return this.importIntoHdfs(this.url, fileSystem, this.path);
        }
        catch (IOException e) {
            this.error = e.getMessage();
            return false;
        }
    }

    public boolean importIntoHdfs(String weburl, FileSystem fileSystem, String path) throws IOException {
        URL url = new URL(weburl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        String[] tiles = weburl.split("/");
        String name = tiles[tiles.length - 1];
        String target = HdfsUtil.path(path, name);
        FSDataOutputStream out = fileSystem.create(new Path(target));
        this.t = new CountingOutputStream((OutputStream)out);
        IOUtils.copyBytes((InputStream)in, (OutputStream)this.t, (Configuration)fileSystem.getConf());
        IOUtils.closeStream((Closeable)in);
        IOUtils.closeStream((Closeable)out);
        return true;
    }

    @Override
    public List<FileItem> getFiles() {
        Vector<FileItem> items = new Vector<FileItem>();
        FileItem file = new FileItem();
        file.setText(FilenameUtils.getName(this.url));
        file.setPath("/");
        file.setId("/");
        file.setSize(FileUtils.byteCountToDisplaySize(this.getFileSize()));
        items.add(file);
        return items;
    }

    @Override
    public String getErrorMessage() {
        return this.error;
    }
}

