/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop.importer;

import genepi.hadoop.HdfsUtil;
import genepi.hadoop.importer.FileItem;
import genepi.hadoop.importer.IImporter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsImporterFtp
implements IImporter {
    private String server;
    private String workingDir;
    private String username = "anonymous";
    private String password = "anonymous@domain.com";
    private String path;
    private CountingOutputStream t;
    private String error;

    public HdfsImporterFtp(String url, String path) {
        this.server = url.split(";")[0];
        if (url.split(";").length > 1) {
            this.username = url.split(";")[1].trim();
        }
        if (url.split(";").length > 2) {
            this.password = url.split(";")[2];
        }
        this.path = path;
        String server1 = this.server.replace("ftp://", "");
        String[] split = server1.split("/", 2);
        this.server = split[0].trim();
        this.workingDir = split[1].trim();
    }

    @Override
    public boolean importFiles() {
        return this.importFiles(null);
    }

    @Override
    public boolean importFiles(String extension) {
        Configuration conf = new Configuration();
        try {
            FileSystem fileSystem = FileSystem.get((Configuration)conf);
            return this.importIntoHdfs(this.server, this.workingDir, this.username, this.password, fileSystem, this.path);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.error = e.getMessage();
            return false;
        }
    }

    public boolean importIntoHdfs(String server, String workingDir, String username, String password, FileSystem fileSystem, String path) throws IOException {
        boolean commandOK;
        block15: {
            commandOK = true;
            if (username == null || username.equals("")) {
                username = "anonymous";
            }
            FTPClient client = new FTPClient();
            try {
                client.connect(server);
                client.enterLocalPassiveMode();
                if (client.login(username, password)) {
                    FTPFile[] ftpFiles = null;
                    if (client.changeWorkingDirectory(workingDir)) {
                        ftpFiles = client.listFiles();
                    } else {
                        String filename = workingDir;
                        String[] tiles = workingDir.split("/");
                        workingDir = "";
                        int i = 0;
                        while (i < tiles.length - 1) {
                            workingDir = String.valueOf(workingDir) + tiles[i];
                            if (i < tiles.length - 2) {
                                workingDir = String.valueOf(workingDir) + "/";
                            }
                            ++i;
                        }
                        ftpFiles = client.listFiles(filename);
                        if (ftpFiles.length == 0) {
                            this.error = "file not found";
                            return false;
                        }
                        client.changeWorkingDirectory(workingDir);
                    }
                    FTPFile[] fTPFileArray = ftpFiles;
                    int n = ftpFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FTPFile ftpFile = fTPFileArray[n2];
                        if (ftpFile.getType() == 0) {
                            String[] tiles = ftpFile.getName().split("/");
                            String name = tiles[tiles.length - 1];
                            String target = HdfsUtil.path(path, name);
                            FSDataOutputStream out = fileSystem.create(new Path(target));
                            client.setFileType(2);
                            client.enterLocalPassiveMode();
                            client.setAutodetectUTF8(true);
                            InputStream inputStream = client.retrieveFileStream(name);
                            IOUtils.copy(inputStream, (OutputStream)out);
                            out.flush();
                            IOUtils.closeQuietly((OutputStream)out);
                            IOUtils.closeQuietly(inputStream);
                            commandOK = client.completePendingCommand();
                        }
                        ++n2;
                    }
                    client.logout();
                    break block15;
                }
                this.error = "access denied";
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error = e.getMessage();
                return false;
            }
            finally {
                client.disconnect();
            }
        }
        return commandOK;
    }

    @Override
    public List<FileItem> getFiles() {
        Vector<FileItem> items = new Vector<FileItem>();
        FileItem file = new FileItem();
        file.setText(FilenameUtils.getName(this.workingDir));
        file.setPath("/");
        file.setId("/");
        file.setSize("-");
        items.add(file);
        return items;
    }

    @Override
    public String getErrorMessage() {
        return this.error;
    }
}

