/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop.common;

import genepi.hadoop.HdfsUtil;
import genepi.hadoop.common.WorkflowContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CommandLineContext
extends WorkflowContext {
    private Map<String, String> params = new HashMap<String, String>();
    private String jobId;
    private Map<String, String> config;

    public CommandLineContext(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("--")) {
                String key = args[i];
                if (++i >= args.length) {
                    throw new Exception("");
                }
                String value = args[i];
                this.params.put(key.replace("--", ""), value);
            }
            ++i;
        }
        this.jobId = "job_" + System.currentTimeMillis();
    }

    @Override
    public String getInput(String param) {
        return this.params.get(param);
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public String getOutput(String param) {
        return this.params.get(param);
    }

    @Override
    public String get(String param) {
        return this.params.get(param);
    }

    @Override
    public void println(String line) {
        System.out.println(line);
    }

    @Override
    public void log(String line) {
        System.out.println(line);
    }

    @Override
    public String getWorkingDirectory() {
        return ".";
    }

    @Override
    public boolean sendMail(String subject, String body) throws Exception {
        return false;
    }

    @Override
    public boolean sendMail(String to, String subject, String body) throws Exception {
        return false;
    }

    @Override
    public boolean sendNotification(String body) throws Exception {
        return false;
    }

    @Override
    public Set<String> getInputs() {
        return this.params.keySet();
    }

    @Override
    public void setInput(String input, String value) {
        this.params.put(input, value);
    }

    @Override
    public void setOutput(String input, String value) {
        this.params.put(input, value);
    }

    @Override
    public void incCounter(String name, int value) {
    }

    @Override
    public void submitCounter(String name) {
    }

    @Override
    public Map<String, Integer> getCounters() {
        return null;
    }

    @Override
    public Object getData(String key) {
        return null;
    }

    @Override
    public String createLinkToFile(String id) {
        return "[NOT AVAILABLE]";
    }

    @Override
    public String createLinkToFile(String id, String filename) {
        return "[NOT AVAILABLE]";
    }

    @Override
    public String getJobName() {
        return this.jobId;
    }

    @Override
    public String getHdfsTemp() {
        return HdfsUtil.path("temp", this.jobId);
    }

    @Override
    public String getLocalTemp() {
        return "temp/" + this.jobId;
    }

    @Override
    public void message(String message, int type) {
        switch (type) {
            case 0: {
                System.out.println("[OK] " + message);
                break;
            }
            case 1: {
                System.out.println("[ERROR] " + message);
                break;
            }
            case 2: {
                System.out.println("[WARN] " + message);
                break;
            }
            case 3: {
                System.out.println("[RUNNING] " + message);
                break;
            }
            default: {
                System.out.println("[INFO] " + message);
            }
        }
    }

    @Override
    public void beginTask(String name) {
        this.message(name, 3);
    }

    @Override
    public void updateTask(String name, int type) {
        this.message(name, type);
    }

    @Override
    public void endTask(String message, int type) {
        this.message(message, type);
    }

    @Override
    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    @Override
    public String getConfig(String param) {
        if (this.config != null) {
            return this.config.get(param);
        }
        return null;
    }
}

