/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop.command;

import genepi.hadoop.command.ICommand;
import genepi.hadoop.command.PipedCommand;
import java.util.List;
import java.util.Vector;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Pipeline
implements ICommand {
    protected static final Log log = LogFactory.getLog(Pipeline.class);
    private List<PipedCommand> commands;
    private String name;
    private List<String> inputs = new Vector<String>();
    private List<String> outputs = new Vector<String>();

    public Pipeline(String name) {
        this.commands = new Vector<PipedCommand>();
        this.name = name;
    }

    public void add(PipedCommand command) {
        if (!this.commands.isEmpty()) {
            PipedCommand prevStep = this.commands.get(this.commands.size() - 1);
            command.readFrom(prevStep);
        }
        this.inputs.addAll(command.getInputs());
        this.outputs.addAll(command.getOutputs());
        this.commands.add(command);
    }

    @Override
    public List<String> getInputs() {
        return this.inputs;
    }

    @Override
    public List<String> getOutputs() {
        return this.outputs;
    }

    @Override
    public String getSignature() {
        String signature = "";
        for (PipedCommand command : this.commands) {
            signature = String.valueOf(signature) + command.getSignature();
        }
        return DigestUtils.md5Hex((String)signature);
    }

    @Override
    public int execute() {
        log.info((Object)("Running pipeline " + this.name + "..."));
        PipedCommand lastStep = this.commands.get(this.commands.size() - 1);
        int result = lastStep.execute();
        if (result == 0) {
            log.info((Object)("Running pipeline " + this.name + " successful."));
        } else {
            log.info((Object)("Running pipeline " + this.name + " failed."));
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

