/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop.command;

import genepi.hadoop.command.CommandStreamHandler;
import genepi.hadoop.command.CommandStreamPipeHandler;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.codec.digest.DigestUtils;

public class PipedCommand {
    protected String cmd;
    private String[] params;
    private boolean silent = false;
    private boolean deleteInput = false;
    private String directory = null;
    private StringBuffer stout = new StringBuffer();
    private String stdoutFileName = null;
    private List<String> inputs = new Vector<String>();
    private List<String> outputs = new Vector<String>();
    private PipedCommand inputCommand = null;
    private PipedCommand outputCommand = null;
    private Process process;

    public PipedCommand(String cmd, String ... params) {
        this.cmd = cmd;
        this.params = params;
    }

    public PipedCommand(String cmd) {
        this.cmd = cmd;
    }

    public void setParams(String ... params) {
        this.params = params;
    }

    public void setParams(List<String> params) {
        this.params = new String[params.size()];
        int i = 0;
        while (i < params.size()) {
            this.params[i] = params.get(i);
            ++i;
        }
    }

    public void saveStdOut(String filename) {
        this.stdoutFileName = filename;
        this.silent = true;
    }

    protected void readFrom(PipedCommand command) {
        this.inputCommand = command;
        this.inputCommand.writeTo(this);
    }

    protected void writeTo(PipedCommand command) {
        this.outputCommand = command;
    }

    protected int execute() {
        if (this.inputCommand != null) {
            this.inputCommand.execute();
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.cmd);
        if (this.params != null) {
            String[] stringArray = this.params;
            int n = this.params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                command.add(param);
                ++n2;
            }
        }
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            if (this.directory != null) {
                builder.directory(new File(this.directory));
            }
            this.process = builder.start();
            Thread inputStreamHandler = null;
            if (this.outputCommand == null) {
                CommandStreamHandler handler = new CommandStreamHandler(this.process.getInputStream(), this.stdoutFileName);
                handler.setSilent(this.silent);
                inputStreamHandler = new Thread(handler);
                inputStreamHandler.start();
            }
            if (this.inputCommand != null) {
                CommandStreamPipeHandler handler = new CommandStreamPipeHandler(this.inputCommand.getOutputStream(), this.process.getOutputStream());
                Thread pipeHandler = new Thread(handler);
                pipeHandler.start();
            }
            Thread errorStreamHandler = new Thread(new CommandStreamHandler(this.process.getErrorStream()));
            errorStreamHandler.start();
            if (this.outputCommand == null) {
                this.process.waitFor();
                inputStreamHandler.interrupt();
                errorStreamHandler.interrupt();
                inputStreamHandler.join();
                errorStreamHandler.join();
                if (this.process.exitValue() != 0) {
                    return this.process.exitValue();
                }
                this.process.destroy();
            }
            if (this.deleteInput) {
                new File(this.cmd).delete();
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public InputStream getOutputStream() {
        return this.process.getInputStream();
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean isDeleteInput() {
        return this.deleteInput;
    }

    public void setDeleteInput(boolean deleteInput) {
        this.deleteInput = deleteInput;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String toString() {
        String result = this.cmd;
        if (this.params != null) {
            String[] stringArray = this.params;
            int n = this.params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                result = String.valueOf(result) + " " + param;
                ++n2;
            }
        }
        return result;
    }

    public String getStdOut() {
        return this.stout.toString();
    }

    public void addInput(String input) {
        this.inputs.add(input);
    }

    public void addOutput(String output) {
        this.outputs.add(output);
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public List<String> getOutputs() {
        return this.outputs;
    }

    private boolean isNoFile(String param) {
        return !this.inputs.contains(param) && !this.outputs.contains(param);
    }

    public String getSignature() {
        String fullCommand = this.cmd;
        String[] stringArray = this.params;
        int n = this.params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (this.isNoFile(param)) {
                fullCommand = String.valueOf(fullCommand) + param;
            }
            ++n2;
        }
        return DigestUtils.md5Hex((String)fullCommand);
    }

    public String getName() {
        return this.cmd;
    }
}

