/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop.command;

import genepi.hadoop.command.ICommand;
import java.util.List;
import java.util.Vector;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandGroup
implements ICommand {
    protected static final Log log = LogFactory.getLog(CommandGroup.class);
    private List<ICommand> commands;
    private List<String> inputs = new Vector<String>();
    private List<String> outputs = new Vector<String>();
    private String name;

    public CommandGroup(String name) {
        this.commands = new Vector<ICommand>();
        this.name = name;
    }

    public void add(ICommand command) {
        this.commands.add(command);
        this.inputs.addAll(command.getInputs());
        this.outputs.addAll(command.getOutputs());
    }

    @Override
    public List<String> getInputs() {
        return this.inputs;
    }

    @Override
    public List<String> getOutputs() {
        return this.outputs;
    }

    @Override
    public String getSignature() {
        String signature = "";
        for (ICommand command : this.commands) {
            signature = String.valueOf(signature) + command.getSignature();
        }
        return DigestUtils.md5Hex((String)signature);
    }

    @Override
    public int execute() {
        log.info((Object)("Running command group " + this.name + "..."));
        for (ICommand command : this.commands) {
            log.info((Object)("  Running command " + command + "..."));
            int result = command.execute();
            if (result == 0) continue;
            log.info((Object)("Running command group " + this.name + " failed."));
            return result;
        }
        log.info((Object)("Running command group " + this.name + " successful."));
        return 0;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

