/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop.command;

import genepi.hadoop.command.CommandStreamHandler;
import genepi.hadoop.command.ICommand;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.codec.digest.DigestUtils;

public class Command
implements ICommand {
    protected String cmd;
    private String[] params;
    private boolean silent = false;
    private boolean deleteInput = false;
    private String directory = null;
    private StringBuffer stout = new StringBuffer();
    private String stdoutFileName = null;
    private String stderrFileName = null;
    private List<String> inputs = new Vector<String>();
    private List<String> outputs = new Vector<String>();

    public Command(String cmd, String ... params) {
        this.cmd = cmd;
        this.params = params;
    }

    public Command(String cmd) {
        this.cmd = cmd;
    }

    public void setParams(String ... params) {
        this.params = params;
    }

    public void setParams(List<String> params) {
        this.params = new String[params.size()];
        int i = 0;
        while (i < params.size()) {
            this.params[i] = params.get(i);
            ++i;
        }
    }

    public void saveStdOut(String filename) {
        this.stdoutFileName = filename;
    }

    public void saveStdErr(String filename) {
        this.stderrFileName = filename;
    }

    @Override
    public int execute() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.cmd);
        if (this.params != null) {
            String[] stringArray = this.params;
            int n = this.params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                command.add(param);
                ++n2;
            }
        }
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            if (this.directory != null) {
                builder.directory(new File(this.directory));
            }
            Process process = builder.start();
            CommandStreamHandler handler = new CommandStreamHandler(process.getInputStream(), this.stdoutFileName);
            handler.setSilent(this.silent);
            Thread inputStreamHandler = new Thread(handler);
            CommandStreamHandler handler2 = new CommandStreamHandler(process.getErrorStream(), this.stderrFileName);
            handler2.setSilent(this.silent);
            Thread errorStreamHandler = new Thread(handler2);
            inputStreamHandler.start();
            errorStreamHandler.start();
            process.waitFor();
            inputStreamHandler.interrupt();
            errorStreamHandler.interrupt();
            inputStreamHandler.join();
            errorStreamHandler.join();
            if (process.exitValue() != 0) {
                return process.exitValue();
            }
            process.destroy();
            if (this.deleteInput) {
                new File(this.cmd).delete();
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean isDeleteInput() {
        return this.deleteInput;
    }

    public void setDeleteInput(boolean deleteInput) {
        this.deleteInput = deleteInput;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String toString() {
        String result = this.cmd;
        if (this.params != null) {
            String[] stringArray = this.params;
            int n = this.params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                result = String.valueOf(result) + " " + param;
                ++n2;
            }
        }
        return result;
    }

    public String getStdOut() {
        return this.stout.toString();
    }

    public void addInput(String input) {
        this.inputs.add(input);
    }

    public void addOutput(String output) {
        this.outputs.add(output);
    }

    @Override
    public List<String> getInputs() {
        return this.inputs;
    }

    @Override
    public List<String> getOutputs() {
        return this.outputs;
    }

    private boolean isNoFile(String param) {
        return !this.inputs.contains(param) && !this.outputs.contains(param);
    }

    @Override
    public String getSignature() {
        String fullCommand = this.cmd;
        String[] stringArray = this.params;
        int n = this.params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (this.isNoFile(param)) {
                fullCommand = String.valueOf(fullCommand) + param;
            }
            ++n2;
        }
        return DigestUtils.md5Hex((String)fullCommand);
    }

    @Override
    public String getName() {
        return this.cmd;
    }

    public String getExecutedCommand() {
        String executedCommand = this.cmd;
        if (this.params != null) {
            String[] stringArray = this.params;
            int n = this.params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                executedCommand = String.valueOf(executedCommand) + " " + param;
                ++n2;
            }
        }
        return executedCommand;
    }
}

