/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop.cache;

import genepi.hadoop.HdfsUtil;
import genepi.hadoop.cache.CommandCacheEntry;
import genepi.hadoop.cache.FolderCacheEntry;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.LineReader;

public class FolderCache {
    protected static final Log log = LogFactory.getLog(FolderCache.class);
    private String cacheDirectory;
    private List<FolderCacheEntry> entries = new Vector<FolderCacheEntry>();
    private List<FolderCacheEntry> updates = new Vector<FolderCacheEntry>();
    public static FolderCache instance = null;
    private boolean loaded = false;

    public static FolderCache getInstance() {
        if (instance == null) {
            instance = new FolderCache();
        }
        return instance;
    }

    private FolderCache() {
    }

    public void load(String cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
        this.entries = new Vector<FolderCacheEntry>();
        this.updates = new Vector<FolderCacheEntry>();
        Configuration conf = new Configuration();
        try {
            FileSystem fileSystem = FileSystem.get((Configuration)conf);
            Path indexFile = new Path(HdfsUtil.path(cacheDirectory, "index"));
            Text line = new Text();
            if (fileSystem.exists(indexFile)) {
                log.info((Object)("Loading cache index file " + indexFile + "..."));
                FSDataInputStream is = fileSystem.open(indexFile);
                LineReader reader = new LineReader((InputStream)is);
                while (reader.readLine(line, 500) > 0) {
                    if (line.toString().length() <= 0) continue;
                    FolderCacheEntry entry = FolderCacheEntry.parse(line.toString());
                    this.entries.add(entry);
                }
                reader.close();
                this.loaded = true;
            } else {
                log.info((Object)("Cache index file " + indexFile + " not present."));
                this.loaded = true;
            }
        }
        catch (Exception e) {
            log.error((Object)"Loading Cache index file failed.", (Throwable)e);
            this.loaded = false;
        }
    }

    public String getCachedDirectory(String signature) {
        if (this.loaded) {
            for (FolderCacheEntry cacheEntry : this.entries) {
                if (!cacheEntry.getSignature().equals(signature)) continue;
                log.info((Object)(String.valueOf(signature) + " is cached."));
                return cacheEntry.getFolder();
            }
            log.info((Object)(String.valueOf(signature) + " is not cached."));
            return null;
        }
        throw new RuntimeException("Cache is not loaded yet.");
    }

    public void cacheFile(String signature, String filename) {
        String name = CommandCacheEntry.getMd5Hex(filename);
        this.cacheFile(signature, filename, name);
    }

    public void cacheFile(String signature, String filename, String name) {
        if (!this.loaded) {
            throw new RuntimeException("Cache is not loaded yet.");
        }
        String folder = HdfsUtil.path(this.cacheDirectory, "data", signature);
        FolderCacheEntry entry = new FolderCacheEntry(signature);
        entry.setFolder(folder);
        log.info((Object)("Put " + signature + " into cache."));
        this.entries.add(entry);
        this.updates.add(entry);
        log.info((Object)("Storing " + filename + " file into cache..."));
        String target = HdfsUtil.path(folder, name);
        HdfsUtil.put(filename, target);
    }

    public void save(Mapper.Context context) {
        String job = context.getJobID().toString();
        String name = context.getTaskAttemptID().toString();
        String target = HdfsUtil.path(this.cacheDirectory, "meta", job, name);
        this.save(target);
    }

    public void save(Reducer.Context context) {
        String job = context.getJobID().toString();
        String name = context.getTaskAttemptID().toString();
        String target = HdfsUtil.path(this.cacheDirectory, "meta", job, name);
        this.save(target);
    }

    public void save(String target) {
        if (this.loaded) {
            if (!this.updates.isEmpty()) {
                log.info((Object)("Write " + this.updates.size() + " changes into cache index file..."));
                Configuration conf = new Configuration();
                try {
                    FileSystem fileSystem = FileSystem.get((Configuration)conf);
                    FSDataOutputStream out = fileSystem.create(new Path(target));
                    for (FolderCacheEntry entry : this.updates) {
                        out.write(entry.toString().getBytes());
                        out.write(10);
                    }
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                log.info((Object)"No change in cache index file.");
            }
        } else {
            throw new RuntimeException("Cache is not loaded yet.");
        }
    }

    protected void saveAll(String target) {
        if (this.loaded) {
            if (!this.updates.isEmpty()) {
                log.info((Object)("Write " + this.updates.size() + " changes into cache index file..."));
                Configuration conf = new Configuration();
                try {
                    FileSystem fileSystem = FileSystem.get((Configuration)conf);
                    FSDataOutputStream out = fileSystem.create(new Path(target));
                    for (FolderCacheEntry entry : this.entries) {
                        out.write(entry.toString().getBytes());
                        out.write(10);
                    }
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                log.info((Object)"No change in cache index file.");
            }
        } else {
            throw new RuntimeException("Cache is not loaded yet.");
        }
    }

    public void updateAndSave(Job job) {
        log.info((Object)"Update cache...");
        if (this.loaded) {
            String name = job.getJobID().toString();
            String directory = HdfsUtil.path(this.cacheDirectory, "meta", name);
            Configuration conf = new Configuration();
            try {
                FileSystem fileSystem = FileSystem.get((Configuration)conf);
                Path splitDirectory = new Path(directory);
                FileStatus[] files = fileSystem.listStatus(splitDirectory);
                if (files != null) {
                    Text line = new Text();
                    FileStatus[] fileStatusArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FileStatus file = fileStatusArray[n2];
                        FSDataInputStream is = fileSystem.open(file.getPath());
                        LineReader reader = new LineReader((InputStream)is);
                        while (reader.readLine(line, 500) > 0) {
                            FolderCacheEntry entry;
                            if (line.toString().length() <= 0 || this.getCachedDirectory((entry = FolderCacheEntry.parse(line.toString())).getSignature()) != null) continue;
                            this.entries.add(entry);
                            this.updates.add(entry);
                        }
                        reader.close();
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("Cache is not loaded yet.");
        }
        String target = HdfsUtil.path(this.cacheDirectory, "index");
        this.saveAll(target);
    }

    public void clear(String directory) {
        log.info((Object)"Clear cache...");
        if (!this.loaded) {
            throw new RuntimeException("Cache is not loaded yet.");
        }
        HdfsUtil.delete(directory);
        log.info((Object)"Cache is empty.");
    }
}

