/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop.cache;

import genepi.hadoop.command.ICommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;

public class CommandCacheEntry {
    private String signature;
    private String[] inputFiles;
    private String[] outputFiles;
    private ICommand command;

    private CommandCacheEntry() {
    }

    public CommandCacheEntry(ICommand command) {
        this.command = command;
        this.signature = command.getSignature();
        this.inputFiles = new String[command.getInputs().size()];
        int i = 0;
        while (i < command.getInputs().size()) {
            this.inputFiles[i] = CommandCacheEntry.getMd5Hex(command.getInputs().get(i));
            ++i;
        }
        this.outputFiles = new String[command.getOutputs().size()];
    }

    public boolean isEqual(CommandCacheEntry entry) {
        String mySignature = entry.getSignature();
        if (this.signature.equals(mySignature)) {
            int i = 0;
            while (i < entry.getInputFiles().length) {
                if (!this.getInputFiles()[i].equals(entry.getInputFiles()[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String getSignature() {
        return this.signature;
    }

    public String[] getOutputFiles() {
        return this.outputFiles;
    }

    public String[] getInputFiles() {
        return this.inputFiles;
    }

    public ICommand getCommand() {
        return this.command;
    }

    public static String getMd5Hex(String filename) {
        try {
            FileInputStream fis = new FileInputStream(new File(filename));
            String md5 = DigestUtils.md5Hex((InputStream)fis);
            return md5;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static CommandCacheEntry parse(String line) {
        String[] tiles = line.split("\t");
        CommandCacheEntry entry = new CommandCacheEntry();
        entry.signature = tiles[0];
        entry.inputFiles = tiles[1].split(" ");
        entry.outputFiles = tiles[2].split(" ");
        return entry;
    }

    public String toString() {
        String result = this.signature;
        result = String.valueOf(result) + "\t";
        int i = 0;
        while (i < this.inputFiles.length) {
            if (i > 0) {
                result = String.valueOf(result) + " ";
            }
            result = String.valueOf(result) + this.inputFiles[i];
            ++i;
        }
        result = String.valueOf(result) + "\t";
        i = 0;
        while (i < this.outputFiles.length) {
            if (i > 0) {
                result = String.valueOf(result) + " ";
            }
            result = String.valueOf(result) + this.outputFiles[i];
            ++i;
        }
        return result;
    }

    public String getName() {
        return this.command.getName();
    }
}

