/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop.cache;

import genepi.hadoop.HdfsUtil;
import genepi.hadoop.cache.CommandCacheEntry;
import genepi.hadoop.command.ICommand;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.LineReader;

public class CommandCache {
    protected static final Log log = LogFactory.getLog(CommandCache.class);
    private String cacheDirectory;
    private List<CommandCacheEntry> entries = new Vector<CommandCacheEntry>();
    private List<CommandCacheEntry> updates = new Vector<CommandCacheEntry>();
    public static CommandCache instance = null;
    private boolean loaded = false;

    public static CommandCache getInstance() {
        if (instance == null) {
            instance = new CommandCache();
        }
        return instance;
    }

    private CommandCache() {
    }

    public void load(String cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
        this.entries = new Vector<CommandCacheEntry>();
        this.updates = new Vector<CommandCacheEntry>();
        Configuration conf = new Configuration();
        try {
            FileSystem fileSystem = FileSystem.get((Configuration)conf);
            Path indexFile = new Path(HdfsUtil.path(cacheDirectory, "index"));
            Text line = new Text();
            if (fileSystem.exists(indexFile)) {
                log.info((Object)("Loading cache index file " + indexFile + "..."));
                FSDataInputStream is = fileSystem.open(indexFile);
                LineReader reader = new LineReader((InputStream)is);
                while (reader.readLine(line, 500) > 0) {
                    if (line.toString().length() <= 0) continue;
                    CommandCacheEntry entry = CommandCacheEntry.parse(line.toString());
                    this.entries.add(entry);
                }
                log.info((Object)(String.valueOf(this.entries.size()) + " entries loaded."));
                reader.close();
                this.loaded = true;
            } else {
                log.info((Object)("Cache index file " + indexFile + " not present."));
                this.loaded = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.loaded = false;
        }
    }

    public boolean isCached(ICommand command) {
        CommandCacheEntry entry = new CommandCacheEntry(command);
        return this.isCached(entry);
    }

    protected boolean isCached(CommandCacheEntry entry) {
        if (this.loaded) {
            for (CommandCacheEntry cacheEntry : this.entries) {
                if (!cacheEntry.isEqual(entry)) continue;
                if (entry.getCommand() != null) {
                    log.info((Object)(String.valueOf(entry.getName()) + " is cached."));
                }
                return true;
            }
            if (entry.getCommand() != null) {
                log.info((Object)(String.valueOf(entry.getName()) + " is not cached."));
            }
            return false;
        }
        throw new RuntimeException("Cache is not loaded yet.");
    }

    public boolean checkOut(ICommand command) {
        if (this.loaded) {
            CommandCacheEntry entry = new CommandCacheEntry(command);
            for (CommandCacheEntry cacheEntry : this.entries) {
                if (!cacheEntry.isEqual(entry)) continue;
                log.info((Object)("Loading " + cacheEntry.getOutputFiles().length + " file/s from cache..."));
                int i = 0;
                while (i < cacheEntry.getOutputFiles().length) {
                    try {
                        HdfsUtil.get(cacheEntry.getOutputFiles()[i], command.getOutputs().get(i));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        throw new RuntimeException("Cache is not loaded yet.");
    }

    public void cache(ICommand command) {
        CommandCacheEntry entry = new CommandCacheEntry(command);
        this.cache(entry);
    }

    protected void cache(CommandCacheEntry entry) {
        if (this.loaded) {
            ICommand command = entry.getCommand();
            log.info((Object)("Put " + entry.getName() + " into cache."));
            this.entries.add(entry);
            this.updates.add(entry);
            log.info((Object)("Storing " + command.getOutputs().size() + " file/s into cache..."));
            int i = 0;
            while (i < command.getOutputs().size()) {
                String outputFile = command.getOutputs().get(i);
                String name = CommandCacheEntry.getMd5Hex(outputFile);
                String target = HdfsUtil.path(this.cacheDirectory, "data", name);
                Path path = new Path(target);
                try {
                    if (!FileSystem.get((Configuration)new Configuration()).exists(path)) {
                        HdfsUtil.put(outputFile, target);
                    }
                    entry.getOutputFiles()[i] = target;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        } else {
            throw new RuntimeException("Cache is not loaded yet.");
        }
    }

    public void save(Mapper.Context context) {
        String job = context.getJobID().toString();
        String name = context.getTaskAttemptID().toString();
        String target = HdfsUtil.path(this.cacheDirectory, "meta", job, name);
        this.save(target);
    }

    public void save(Reducer.Context context) {
        String job = context.getJobID().toString();
        String name = context.getTaskAttemptID().toString();
        String target = HdfsUtil.path(this.cacheDirectory, "meta", job, name);
        this.save(target);
    }

    public void save(String target) {
        if (this.loaded) {
            if (!this.updates.isEmpty()) {
                log.info((Object)("Write " + this.updates.size() + " changes into cache index file..."));
                Configuration conf = new Configuration();
                try {
                    FileSystem fileSystem = FileSystem.get((Configuration)conf);
                    FSDataOutputStream out = fileSystem.create(new Path(target));
                    for (CommandCacheEntry entry : this.updates) {
                        out.write(entry.toString().getBytes());
                        out.write(10);
                    }
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                log.info((Object)"No changes on cache.");
            }
        } else {
            throw new RuntimeException("Cache is not loaded yet.");
        }
    }

    protected void saveAll(String target) {
        if (this.loaded) {
            if (!this.updates.isEmpty()) {
                log.info((Object)("Write " + this.updates.size() + " changes into cache index file..."));
                Configuration conf = new Configuration();
                try {
                    FileSystem fileSystem = FileSystem.get((Configuration)conf);
                    FSDataOutputStream out = fileSystem.create(new Path(target));
                    for (CommandCacheEntry entry : this.entries) {
                        out.write(entry.toString().getBytes());
                        out.write(10);
                    }
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                log.info((Object)"No changes on cache.");
            }
        } else {
            throw new RuntimeException("Cache is not loaded yet.");
        }
    }

    public void updateAndSave(Job job) {
        log.info((Object)"Update cache...");
        if (this.loaded) {
            String name = job.getJobID().toString();
            String directory = HdfsUtil.path(this.cacheDirectory, "meta", name);
            Configuration conf = new Configuration();
            try {
                FileSystem fileSystem = FileSystem.get((Configuration)conf);
                Path splitDirectory = new Path(directory);
                FileStatus[] files = fileSystem.listStatus(splitDirectory);
                if (files != null) {
                    Text line = new Text();
                    FileStatus[] fileStatusArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FileStatus file = fileStatusArray[n2];
                        FSDataInputStream is = fileSystem.open(file.getPath());
                        LineReader reader = new LineReader((InputStream)is);
                        while (reader.readLine(line, 500) > 0) {
                            CommandCacheEntry entry;
                            if (line.toString().length() <= 0 || this.isCached(entry = CommandCacheEntry.parse(line.toString()))) continue;
                            this.entries.add(entry);
                            this.updates.add(entry);
                        }
                        reader.close();
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("Cache is not loaded yet.");
        }
        String target = HdfsUtil.path(this.cacheDirectory, "index");
        this.saveAll(target);
    }

    public void clear(String directory) {
        log.info((Object)"Clear cache...");
        if (!this.loaded) {
            throw new RuntimeException("Cache is not loaded yet.");
        }
        HdfsUtil.delete(directory);
        log.info((Object)"Cache is empty.");
    }
}

