/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;

public class PreferenceStore {
    private Properties properties = new Properties();

    public PreferenceStore(File file) {
        this.load(file);
    }

    public PreferenceStore(Configuration configuration) {
        this.load(configuration);
    }

    public void load(File file) {
        try {
            this.properties.load(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load(Configuration configuration) {
        Map pairs = configuration.getValByRegex("cloudgene.*");
        for (String key : pairs.keySet()) {
            String cleanKey = key.replace("cloudgene.", "");
            String value = (String)pairs.get(key);
            this.properties.setProperty(cleanKey, value);
        }
    }

    public void write(Configuration configuration) {
        for (Object key : this.properties.keySet()) {
            String newKey = "cloudgene." + key.toString();
            String value = this.properties.getProperty(key.toString());
            configuration.set(newKey, value);
        }
    }

    public String getString(String key) {
        return this.properties.getProperty(key);
    }

    public void setString(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public Set<Object> getKeys() {
        return this.properties.keySet();
    }
}

