/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.LineReader;

public class HdfsUtil {
    static Configuration defaultConfiguration = new Configuration();

    public static void setDefaultConfiguration(Configuration defaultConfiguration) {
        HdfsUtil.defaultConfiguration = defaultConfiguration;
    }

    public static Configuration getConfiguration() {
        return new Configuration(defaultConfiguration);
    }

    public static FileSystem getFileSystem() throws IOException {
        Configuration configuration = HdfsUtil.getConfiguration();
        FileSystem fileSystem = FileSystem.get((Configuration)configuration);
        return fileSystem;
    }

    public static void get(String hdfs, String filename, Configuration configuration) throws IOException {
        Path path;
        FileSystem fileSystem = FileSystem.get((Configuration)configuration);
        if (fileSystem.isDirectory(path = new Path(hdfs))) {
            FileStatus[] files;
            DataOutputStream fos = new DataOutputStream(new FileOutputStream(filename));
            FileStatus[] fileStatusArray = files = fileSystem.listStatus(new Path(hdfs));
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                FileStatus file = fileStatusArray[n2];
                if (!file.isDir()) {
                    FSDataInputStream is = fileSystem.open(file.getPath());
                    byte[] readData = new byte[1024];
                    int i = is.read(readData);
                    long size = i;
                    while (i != -1) {
                        fos.write(readData, 0, i);
                        i = is.read(readData);
                        size += (long)i;
                    }
                    is.close();
                }
                ++n2;
            }
            fos.close();
        } else {
            FileOutputStream fos = new FileOutputStream(filename);
            FSDataInputStream is = fileSystem.open(path);
            byte[] readData = new byte[1024];
            int i = is.read(readData);
            long size = i;
            while (i != -1) {
                fos.write(readData, 0, i);
                i = is.read(readData);
                size += (long)i;
            }
            is.close();
            fos.close();
        }
    }

    public static void getFolder(String hdfs, String filename, Configuration configuration) throws IOException {
        FileSystem fileSystem = FileSystem.get((Configuration)configuration);
        Path path = new Path(hdfs);
        FileStatus[] files = fileSystem.listStatus(path);
        new File(filename).mkdirs();
        FileStatus[] fileStatusArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            FileStatus file = fileStatusArray[n2];
            if (!file.isDir()) {
                DataOutputStream fos = new DataOutputStream(new FileOutputStream(String.valueOf(filename) + "/" + file.getPath().getName()));
                FSDataInputStream is = fileSystem.open(file.getPath());
                byte[] readData = new byte[1024];
                int i = is.read(readData);
                while (i != -1) {
                    fos.write(readData, 0, i);
                    i = is.read(readData);
                }
                is.close();
                fos.close();
            } else {
                HdfsUtil.getFolder(HdfsUtil.path(hdfs, file.getPath().getName()), String.valueOf(filename) + "/" + file.getPath().getName(), configuration);
            }
            ++n2;
        }
    }

    public static void getFolder(String hdfs, String filename) throws IOException {
        Configuration configuration = HdfsUtil.getConfiguration();
        HdfsUtil.getFolder(hdfs, filename, configuration);
    }

    public static void get(String hdfs, String filename) throws IOException {
        Configuration configuration = HdfsUtil.getConfiguration();
        HdfsUtil.get(hdfs, filename, configuration);
    }

    public static boolean exists(String filename, Configuration conf) {
        try {
            Path path = new Path(filename);
            FileSystem fileSystem = FileSystem.get((Configuration)conf);
            return fileSystem.exists(path);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean copy(String source, String target) {
        Configuration configuration = HdfsUtil.getConfiguration();
        return HdfsUtil.copy(source, target, configuration);
    }

    public static boolean copy(String source, String target, Configuration conf) {
        try {
            Path pathSource = new Path(source);
            Path pathTarget = new Path(target);
            FileSystem fileSystem = FileSystem.get((Configuration)conf);
            return FileUtil.copy((FileSystem)fileSystem, (Path)pathSource, (FileSystem)fileSystem, (Path)pathTarget, (boolean)false, (Configuration)conf);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean exists(String filename) {
        Configuration configuration = HdfsUtil.getConfiguration();
        return HdfsUtil.exists(filename, configuration);
    }

    public static void put(String filename, String target, Configuration conf) {
        try {
            File file = new File(filename);
            if (file.isDirectory()) {
                File[] files;
                File[] fileArray = files = file.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File subFile = fileArray[n2];
                    HdfsUtil.put(subFile.getPath(), HdfsUtil.path(target, subFile.getName()));
                    ++n2;
                }
            } else {
                FileInputStream in = new FileInputStream(filename);
                FileSystem fileSystem = FileSystem.get((Configuration)conf);
                FSDataOutputStream out = fileSystem.create(new Path(target));
                org.apache.hadoop.io.IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)fileSystem.getConf());
                org.apache.hadoop.io.IOUtils.closeStream((Closeable)in);
                org.apache.hadoop.io.IOUtils.closeStream((Closeable)out);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void put(String filename, String target) {
        Configuration configuration = HdfsUtil.getConfiguration();
        HdfsUtil.put(filename, target, configuration);
    }

    public static boolean delete(String directory, Configuration configuration) {
        Path path = new Path(directory);
        try {
            FileSystem fileSystem = FileSystem.get((Configuration)configuration);
            if (fileSystem.exists(path)) {
                fileSystem.delete(path);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean delete(String directory) {
        Configuration configuration = HdfsUtil.getConfiguration();
        return HdfsUtil.delete(directory, configuration);
    }

    public static String path(String ... paths) {
        String result = "";
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            if (!path.isEmpty()) {
                result = i > 0 && !path.startsWith("/") && !result.endsWith("/") ? String.valueOf(result) + "/" + path : String.valueOf(result) + path;
            }
            ++i;
        }
        return result;
    }

    public static void getAsZip(String zipFile, String hdfs, boolean merge, Configuration configuration) {
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
            FileSystem fileSystem = FileSystem.get((Configuration)configuration);
            Path pathFolder = new Path(hdfs);
            FileStatus[] files = fileSystem.listStatus(pathFolder);
            if (merge) {
                out.putNextEntry(new ZipEntry(pathFolder.getName()));
            }
            FileStatus[] fileStatusArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                FileStatus file = fileStatusArray[n2];
                Path path = file.getPath();
                if (!file.isDir() && !file.getPath().getName().startsWith("_")) {
                    int len;
                    FSDataInputStream in = fileSystem.open(path);
                    if (!merge) {
                        out.putNextEntry(new ZipEntry(path.getName()));
                    }
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    if (!merge) {
                        out.closeEntry();
                    }
                    in.close();
                }
                ++n2;
            }
            if (merge) {
                out.closeEntry();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getAsZip(String zipFile, String hdfs, boolean merge) {
        Configuration configuration = HdfsUtil.getConfiguration();
        HdfsUtil.getAsZip(zipFile, hdfs, merge, configuration);
    }

    public static void putZip(String filename, String folder, Configuration configuration) {
        try {
            FileSystem filesystem = FileSystem.get((Configuration)configuration);
            ZipInputStream zipinputstream = new ZipInputStream(new FileInputStream(filename));
            byte[] buf = new byte[1024];
            ZipEntry zipentry = zipinputstream.getNextEntry();
            while (zipentry != null) {
                String entryName = zipentry.getName();
                if (!zipentry.isDirectory()) {
                    int n;
                    String target = HdfsUtil.path(folder, entryName);
                    FSDataOutputStream out = filesystem.create(new Path(target));
                    while ((n = zipinputstream.read(buf, 0, 1024)) > -1) {
                        out.write(buf, 0, n);
                    }
                    out.close();
                    zipinputstream.closeEntry();
                }
                zipentry = zipinputstream.getNextEntry();
            }
            zipinputstream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void putTarGz(String filename, String folder) {
        Configuration configuration = HdfsUtil.getConfiguration();
        HdfsUtil.putTarGz(filename, folder, configuration);
    }

    public static void putTarGz(String filename, String folder, Configuration configuration) {
        int BUFFER_SIZE = 1024;
        try {
            TarArchiveEntry entry;
            FileSystem filesystem = FileSystem.get((Configuration)configuration);
            GzipCompressorInputStream gzipIn = new GzipCompressorInputStream((InputStream)new FileInputStream(filename));
            TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzipIn);
            while ((entry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
                int count;
                String entryName = entry.getName();
                if (entry.isDirectory()) continue;
                String target = HdfsUtil.path(folder, entryName);
                FSDataOutputStream out = filesystem.create(new Path(target));
                byte[] data = new byte[BUFFER_SIZE];
                while ((count = tarIn.read(data, 0, BUFFER_SIZE)) != -1) {
                    out.write(data, 0, count);
                }
                out.close();
            }
            tarIn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void putZip(String filename, String folder) {
        Configuration configuration = HdfsUtil.getConfiguration();
        HdfsUtil.putZip(filename, folder, configuration);
    }

    public static void mergeAndGz(String local, String hdfs, boolean removeHeader, String ext) throws FileNotFoundException, IOException {
        GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(local));
        HdfsUtil.merge(out, hdfs, removeHeader, ext);
    }

    public static void merge(String local, String hdfs, boolean removeHeader) throws IOException {
        FileOutputStream out = new FileOutputStream(local);
        HdfsUtil.merge(out, hdfs, removeHeader, null);
    }

    public static void merge(OutputStream out, String hdfs, boolean removeHeader, String ext) throws IOException {
        FileSystem fileSystem = HdfsUtil.getFileSystem();
        Path pathFolder = new Path(hdfs);
        FileStatus[] files = fileSystem.listStatus(pathFolder);
        Vector<String> filenames = new Vector<String>();
        if (files != null) {
            FileStatus[] fileStatusArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                FileStatus file = fileStatusArray[n2];
                if (!(file.isDir() || file.getPath().getName().startsWith("_") || ext != null && !file.getPath().getName().endsWith(ext))) {
                    filenames.add(file.getPath().toString());
                }
                ++n2;
            }
            Collections.sort(filenames);
            Text line = new Text();
            boolean firstFile = true;
            for (String filename : filenames) {
                Path path = new Path(filename);
                FSDataInputStream in = fileSystem.open(path);
                LineReader reader = new LineReader((InputStream)in);
                boolean header = true;
                while (reader.readLine(line, 1000) > 0) {
                    if (removeHeader) {
                        if (header) {
                            if (firstFile) {
                                out.write(line.toString().getBytes());
                                firstFile = false;
                            }
                            header = false;
                            continue;
                        }
                        out.write(10);
                        out.write(line.toString().getBytes());
                        continue;
                    }
                    if (header) {
                        if (firstFile) {
                            firstFile = false;
                        } else {
                            out.write(10);
                        }
                        header = false;
                    } else {
                        out.write(10);
                    }
                    out.write(line.toString().getBytes());
                }
                line.clear();
                in.close();
                reader.close();
            }
            out.close();
        }
    }

    public static void mergeFolderBinary(String local, String hdfs) throws IOException {
        HdfsUtil.mergeFolderBinary(local, hdfs, null);
    }

    public static void mergeFolderBinary(String localFile, String hdfs, String header) throws IOException {
        List<String> files = HdfsUtil.getFiles(hdfs);
        FileOutputStream out = new FileOutputStream(localFile);
        if (header != null) {
            out.write(new String(header).getBytes());
            out.write("\n".getBytes());
        }
        for (String file : files) {
            DataInputStream in = HdfsUtil.open(file);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
        }
        out.close();
    }

    public static void join(String local, String hdfs, int offset, String delimiter, String ext) {
        try {
            FileOutputStream out = new FileOutputStream(local);
            HdfsUtil.join(out, hdfs, offset, delimiter, ext);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void joinAndGz(String local, String hdfs, int offset, String delimiter, String ext) {
        try {
            GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(local));
            HdfsUtil.join(out, hdfs, offset, delimiter, ext);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void join(OutputStream out, String hdfs, int offset, String delimiter, String ext) {
        try {
            FileSystem fileSystem = HdfsUtil.getFileSystem();
            Path pathFolder = new Path(hdfs);
            FileStatus[] files = fileSystem.listStatus(pathFolder);
            Vector<String> filenames = new Vector<String>();
            if (files != null) {
                FileStatus[] fileStatusArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    FileStatus file = fileStatusArray[n2];
                    if (!(file.isDir() || file.getPath().getName().startsWith("_") || ext != null && !file.getPath().getName().endsWith(ext))) {
                        filenames.add(file.getPath().toString());
                    }
                    ++n2;
                }
                Collections.sort(filenames);
                Text line = new Text();
                FSDataInputStream[] streams = new FSDataInputStream[filenames.size()];
                LineReader[] readers = new LineReader[filenames.size()];
                boolean[] empty = new boolean[filenames.size()];
                int i = 0;
                while (i < filenames.size()) {
                    Path path = new Path((String)filenames.get(i));
                    streams[i] = fileSystem.open(path);
                    readers[i] = new LineReader((InputStream)streams[i]);
                    empty[i] = false;
                    ++i;
                }
                boolean end = false;
                boolean firstLine = true;
                while (!end) {
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        out.write(10);
                    }
                    boolean firstColumn = true;
                    end = true;
                    int i2 = 0;
                    while (i2 < filenames.size()) {
                        if (!empty[i2]) {
                            boolean read;
                            boolean bl = read = readers[i2].readLine(line, 1000000) > 0;
                            if (read) {
                                if (firstColumn) {
                                    out.write(line.toString().getBytes());
                                    firstColumn = false;
                                } else {
                                    out.write(delimiter.getBytes());
                                    out.write(line.toString().getBytes());
                                }
                                end = false;
                            } else {
                                empty[i2] = true;
                            }
                        }
                        ++i2;
                    }
                }
                int i3 = 0;
                while (i3 < filenames.size()) {
                    streams[i3].close();
                    readers[i3].close();
                    ++i3;
                }
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setExecutable(String filename, boolean execute) {
        try {
            FileSystem fileSystem = HdfsUtil.getFileSystem();
            FsPermission other = fileSystem.getFileStatus(new Path(filename)).getPermission();
            FsPermission permission = new FsPermission(FsAction.ALL, other.getGroupAction(), other.getOtherAction());
            fileSystem.setPermission(new Path(filename), permission);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean canExecute(String filename) {
        try {
            FileSystem fileSystem = HdfsUtil.getFileSystem();
            FsPermission permission = fileSystem.getFileStatus(new Path(filename)).getPermission();
            return permission.getUserAction().implies(FsAction.EXECUTE);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean canExecute(Path path) {
        try {
            FileSystem fileSystem = HdfsUtil.getFileSystem();
            FsPermission permission = fileSystem.getFileStatus(path).getPermission();
            return permission.getUserAction().implies(FsAction.EXECUTE);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static DataInputStream open(String filename) throws IOException {
        FileSystem fileSystem = HdfsUtil.getFileSystem();
        Path path = new Path(filename);
        return fileSystem.open(path);
    }

    public static FSDataOutputStream create(String filename) throws IOException {
        FileSystem fileSystem = HdfsUtil.getFileSystem();
        Path path = new Path(filename);
        return fileSystem.create(path);
    }

    public static List<String> getFiles(String hdfs) throws IOException {
        return HdfsUtil.getFiles(hdfs, null);
    }

    public static List<String> getFiles(String hdfs, String ext) throws IOException {
        FileSystem fileSystem = HdfsUtil.getFileSystem();
        Path pathFolder = new Path(hdfs);
        FileStatus[] files = fileSystem.listStatus(pathFolder);
        Vector<String> filenames = new Vector<String>();
        if (files != null) {
            FileStatus[] fileStatusArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                FileStatus file = fileStatusArray[n2];
                if (!(file.isDir() || file.getPath().getName().startsWith("_") || ext != null && !file.getPath().getName().endsWith(ext))) {
                    filenames.add(file.getPath().toString());
                }
                ++n2;
            }
            Collections.sort(filenames);
        }
        return filenames;
    }

    public static List<String> getDirectories(String hdfs) throws IOException {
        FileSystem fileSystem = HdfsUtil.getFileSystem();
        Path pathFolder = new Path(hdfs);
        FileStatus[] files = fileSystem.listStatus(pathFolder);
        Vector<String> filenames = new Vector<String>();
        if (files != null) {
            FileStatus[] fileStatusArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                FileStatus file = fileStatusArray[n2];
                if (file.isDir() && !file.getPath().getName().startsWith("_")) {
                    filenames.add(file.getPath().toString());
                }
                ++n2;
            }
            Collections.sort(filenames);
        }
        return filenames;
    }

    public static String makeAbsolute(String path) {
        try {
            FileSystem fileSystem = HdfsUtil.getFileSystem();
            String temp = "";
            temp = fileSystem.getHomeDirectory().toString().startsWith("file:/") ? path : String.valueOf(fileSystem.getHomeDirectory().toString()) + "/" + path;
            temp = temp.replaceFirst("//([a-zA-Z\\-.\\d]*)(:(\\d*))?/", "///");
            return temp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isAbsolute(String path) {
        return path.startsWith("hdfs://");
    }

    public static void compress(String zipFile, String hdfs) {
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
            FileSystem fileSystem = HdfsUtil.getFileSystem();
            Path pathFolder = new Path(hdfs);
            FileStatus[] files = fileSystem.listStatus(pathFolder);
            if (files != null) {
                FileStatus[] fileStatusArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    FileStatus file = fileStatusArray[n2];
                    Path path = file.getPath();
                    if (!file.isDir() && !file.getPath().getName().startsWith("_")) {
                        int len;
                        FSDataInputStream in = fileSystem.open(path);
                        out.putNextEntry(new ZipEntry(path.getName()));
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        out.closeEntry();
                        in.close();
                    }
                    ++n2;
                }
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void compressAndMerge(String zipFile, String hdfs, boolean removeHeader) {
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
            FileSystem fileSystem = HdfsUtil.getFileSystem();
            Path pathFolder = new Path(hdfs);
            FileStatus[] files = fileSystem.listStatus(pathFolder);
            out.putNextEntry(new ZipEntry(String.valueOf(pathFolder.getName()) + ".txt"));
            Text line = new Text();
            if (files != null) {
                boolean firstFile = true;
                FileStatus[] fileStatusArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    FileStatus file = fileStatusArray[n2];
                    Path path = file.getPath();
                    if (!(file.isDir() || file.getPath().getName().startsWith("_") || file.getPath().getName().startsWith(".pig_schema"))) {
                        FSDataInputStream in = fileSystem.open(path);
                        LineReader reader = new LineReader((InputStream)in);
                        boolean header = true;
                        while (reader.readLine(line, 1000) > 0) {
                            if (removeHeader) {
                                if (header) {
                                    if (firstFile) {
                                        out.write(line.toString().getBytes());
                                        firstFile = false;
                                    }
                                    header = false;
                                    continue;
                                }
                                out.write(10);
                                out.write(line.toString().getBytes());
                                continue;
                            }
                            if (header) {
                                if (firstFile) {
                                    firstFile = false;
                                } else {
                                    out.write(10);
                                }
                                header = false;
                            } else {
                                out.write(10);
                            }
                            out.write(line.toString().getBytes());
                        }
                        line.clear();
                        in.close();
                        reader.close();
                    }
                    ++n2;
                }
                out.closeEntry();
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportDirectoryAndMerge(String folder, String name, String hdfs, boolean removeHeader) {
        try {
            FileOutputStream out = null;
            FileSystem fileSystem = HdfsUtil.getFileSystem();
            Path pathFolder = new Path(hdfs);
            FileStatus[] files = fileSystem.listStatus(pathFolder);
            out = new FileOutputStream(String.valueOf(folder) + "/" + name + ".txt");
            Text line = new Text();
            if (files != null) {
                boolean firstFile = true;
                FileStatus[] fileStatusArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    FileStatus file = fileStatusArray[n2];
                    Path path = file.getPath();
                    if (!(file.isDir() || file.getPath().getName().startsWith("_") || file.getPath().getName().startsWith(".pig_schema"))) {
                        FSDataInputStream in = fileSystem.open(path);
                        LineReader reader = new LineReader((InputStream)in);
                        boolean header = true;
                        while (reader.readLine(line, 1000) > 0) {
                            if (removeHeader) {
                                if (header) {
                                    if (firstFile) {
                                        out.write(line.toString().getBytes());
                                        firstFile = false;
                                    }
                                    header = false;
                                    continue;
                                }
                                out.write(10);
                                out.write(line.toString().getBytes());
                                continue;
                            }
                            if (header) {
                                if (firstFile) {
                                    firstFile = false;
                                } else {
                                    out.write(10);
                                }
                                header = false;
                            } else {
                                out.write(10);
                            }
                            out.write(line.toString().getBytes());
                        }
                        line.clear();
                        in.close();
                        reader.close();
                    }
                    ++n2;
                }
                out.close();
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportDirectory(String folder, String name, String hdfs) {
        byte[] buf = new byte[1024];
        try {
            FileSystem fileSystem = HdfsUtil.getFileSystem();
            Path pathFolder = new Path(hdfs);
            FileStatus[] files = fileSystem.listStatus(pathFolder);
            System.out.println("export folder " + hdfs);
            if (files != null) {
                FileStatus[] fileStatusArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    FileStatus file = fileStatusArray[n2];
                    Path path = file.getPath();
                    if (!file.isDirectory() && !file.getPath().getName().startsWith("_")) {
                        int len;
                        FSDataInputStream in = fileSystem.open(path);
                        FileOutputStream out = new FileOutputStream(String.valueOf(folder) + "/" + path.getName());
                        System.out.println("  export file " + path);
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        out.close();
                        in.close();
                    } else if (file.isDirectory()) {
                        HdfsUtil.exportDirectory(folder, name, HdfsUtil.path(hdfs, path.getName()));
                    }
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportFile(String folder, String hdfs) {
        byte[] buf = new byte[1024];
        try {
            int len;
            FileSystem fileSystem = HdfsUtil.getFileSystem();
            Path path = new Path(hdfs);
            FSDataInputStream in = fileSystem.open(path);
            FileOutputStream out = new FileOutputStream(String.valueOf(folder) + "/" + path.getName());
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.close();
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void compressFile(String folder, String hdfs) {
        byte[] buf = new byte[1024];
        try {
            int len;
            FileSystem fileSystem = HdfsUtil.getFileSystem();
            Path path = new Path(hdfs);
            FSDataInputStream in = fileSystem.open(path);
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(String.valueOf(folder) + "/" + path.getName() + ".zip"));
            out.putNextEntry(new ZipEntry(path.getName()));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            out.close();
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean createDirectory(FileSystem fileSystem, String directory) {
        Path path = new Path(directory);
        try {
            fileSystem.mkdirs(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean createDirectory(String directory) {
        try {
            FileSystem fileSystem = HdfsUtil.getFileSystem();
            return HdfsUtil.createDirectory(fileSystem, directory);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean rename(FileSystem fileSystem, String oldPath, String newPath) {
        Path old = new Path(oldPath);
        Path newP = new Path(newPath);
        try {
            fileSystem.rename(old, newP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean rename(String oldPath, String newPath) {
        try {
            FileSystem fileSystem = HdfsUtil.getFileSystem();
            return HdfsUtil.rename(fileSystem, oldPath, newPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void checkOut(String hdfs, String filename) throws IOException {
        Path path;
        FileSystem fileSystem = HdfsUtil.getFileSystem();
        if (fileSystem.isDirectory(path = new Path(hdfs))) {
            FileStatus[] files;
            DataOutputStream fos = new DataOutputStream(new FileOutputStream(filename));
            Path headerPath = new Path(String.valueOf(hdfs) + "/.pig_header");
            if (fileSystem.exists(headerPath)) {
                FSDataInputStream is = fileSystem.open(headerPath);
                LineReader reader = new LineReader((InputStream)is);
                Text header = new Text();
                reader.readLine(header);
                reader.close();
                is.close();
                fos.writeBytes(String.valueOf(header.toString()) + "\n");
            }
            FileStatus[] fileStatusArray = files = fileSystem.listStatus(new Path(hdfs));
            int n = files.length;
            int header = 0;
            while (header < n) {
                FileStatus file = fileStatusArray[header];
                if (!(file.isDir() || file.getPath().getName().startsWith(".") || file.getPath().getName().startsWith("_"))) {
                    FSDataInputStream is = fileSystem.open(file.getPath());
                    byte[] readData = new byte[1024];
                    int i = is.read(readData);
                    long size = i;
                    while (i != -1) {
                        fos.write(readData, 0, i);
                        i = is.read(readData);
                        size += (long)i;
                    }
                    is.close();
                }
                ++header;
            }
            fos.close();
        } else {
            FileOutputStream fos = new FileOutputStream(filename);
            FSDataInputStream is = fileSystem.open(path);
            byte[] readData = new byte[1024];
            int i = is.read(readData);
            long size = i;
            while (i != -1) {
                fos.write(readData, 0, i);
                i = is.read(readData);
                size += (long)i;
            }
            is.close();
            fos.close();
            System.out.println("Check out file done... (" + size + " bytes)");
        }
    }
}

