/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop;

import genepi.hadoop.HdfsUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.util.VersionInfo;

public class HadoopUtil {
    static HadoopUtil instance = null;
    private JobClient client = null;
    private static final Log log = LogFactory.getLog(HadoopUtil.class);

    public static HadoopUtil getInstance() {
        if (instance == null) {
            instance = new HadoopUtil();
        }
        return instance;
    }

    private HadoopUtil() {
        try {
            this.client = new JobClient(HdfsUtil.getConfiguration());
        }
        catch (IOException e) {
            log.error((Object)"JobClient init failed.", (Throwable)e);
        }
    }

    public void killAll() {
        try {
            if (this.client.getAllJobs() != null) {
                JobStatus[] jobStatusArray = this.client.getAllJobs();
                int n = jobStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JobStatus s = jobStatusArray[n2];
                    if (s.getRunState() == 1 || s.getRunState() == 4) {
                        RunningJob job = this.client.getJob(s.getJobID());
                        job.killJob();
                    }
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Kill All failed.", (Throwable)e);
        }
    }

    public List<JobStatus> getRunningJobs() {
        Vector<JobStatus> result = new Vector<JobStatus>();
        try {
            if (this.client.getAllJobs() != null) {
                JobStatus[] jobStatusArray = this.client.getAllJobs();
                int n = jobStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JobStatus s = jobStatusArray[n2];
                    if (s.getRunState() == 1 || s.getRunState() == 4) {
                        result.add(s);
                    }
                    ++n2;
                }
            }
            return result;
        }
        catch (IOException e) {
            log.error((Object)"get Running jobs failed.", (Throwable)e);
            return result;
        }
    }

    public void kill(String id) throws IOException {
        RunningJob job = this.getJob(id);
        job.killJob();
    }

    public RunningJob getJob(String id) {
        RunningJob result = null;
        try {
            JobStatus[] activeJobs = this.client.getAllJobs();
            if (activeJobs != null) {
                JobStatus[] jobStatusArray = activeJobs;
                int n = activeJobs.length;
                int n2 = 0;
                while (n2 < n) {
                    JobStatus js = jobStatusArray[n2];
                    if (js.getJobID().equals((Object)JobID.forName((String)id))) {
                        result = this.client.getJob(js.getJobID());
                        break;
                    }
                    ++n2;
                }
                return result;
            }
        }
        catch (IOException e) {
            log.error((Object)"Get Job failed.", (Throwable)e);
        }
        return result;
    }

    public TaskReport[] getMapperByJob(String id) {
        TaskReport[] result = null;
        try {
            result = this.client.getMapTaskReports(id);
            return result;
        }
        catch (IOException e) {
            log.error((Object)"Get Mapper failed.", (Throwable)e);
            return result;
        }
    }

    public TaskReport[] getReducerByJob(String id) {
        TaskReport[] result = null;
        try {
            result = this.client.getReduceTaskReports(id);
            return result;
        }
        catch (IOException e) {
            log.error((Object)"Get Reducer failed.", (Throwable)e);
            return result;
        }
    }

    public ClusterStatus getClusterDetails() {
        try {
            return this.client.getClusterStatus(true);
        }
        catch (IOException e) {
            log.error((Object)"Get cluster details failed.", (Throwable)e);
            return null;
        }
    }

    public boolean isInSafeMode() {
        try {
            FileSystem fs = this.client.getFs();
            if (fs instanceof DistributedFileSystem) {
                DistributedFileSystem dfs = (DistributedFileSystem)fs;
                FsStatus ds = dfs.getStatus();
                return dfs.isInSafeMode();
            }
            return false;
        }
        catch (IOException e) {
            log.error((Object)"Get safe mode failed.", (Throwable)e);
            return false;
        }
    }

    public String getVersion() {
        return VersionInfo.getVersion();
    }

    public void downloadFailedLogs(RunningJob runningJob, String folder) {
        log.info((Object)"Downloading events...");
        LinkedList<TaskCompletionEvent> completionEvents = new LinkedList<TaskCompletionEvent>();
        try {
            TaskCompletionEvent[] bunchOfEvents;
            while ((bunchOfEvents = runningJob.getTaskCompletionEvents(0)) != null && bunchOfEvents.length != 0) {
                completionEvents.addAll(Arrays.asList(bunchOfEvents));
            }
        }
        catch (Exception e) {
            log.error((Object)"Downloading events failed.", (Throwable)e);
            return;
        }
        log.info((Object)("Downloaded " + completionEvents.size() + " events."));
        log.info((Object)("Downloading " + completionEvents.size() + " log files..."));
        for (TaskCompletionEvent taskCompletionEvent : completionEvents) {
        }
        log.info((Object)"Downloading log files successful.");
    }
}

