/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop;

import genepi.hadoop.CacheStore;
import genepi.hadoop.HdfsUtil;
import genepi.hadoop.PreferenceStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public abstract class HadoopJob {
    protected Log log = null;
    public static final String CONFIG_FILE = "job.config";
    private String output;
    private String[] inputs;
    private String name;
    private Configuration configuration;
    private FileSystem fileSystem;
    private boolean canSet = false;
    private Job job;
    private String taskLocalData = "/temp/dist";
    private Class myClass = null;
    private String jar = null;
    private RunningJob runningJob = null;

    public HadoopJob(String name, Log log) {
        this.log = log;
        this.name = name;
        this.configuration = HdfsUtil.getConfiguration();
        this.configuration.set("mapred.task.timeout", "0");
        try {
            this.fileSystem = FileSystem.get((Configuration)this.configuration);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error((Object)"Creating FileSystem class failed.", (Throwable)e);
        }
        this.canSet = true;
    }

    public HadoopJob(String name) {
        this(name, LogFactory.getLog(HadoopJob.class));
    }

    private String getFolder(Class clazz) {
        return new File(clazz.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
    }

    protected void readConfigFile() {
        String folder = null;
        folder = this.myClass != null ? this.getFolder(this.myClass) : this.getFolder(HadoopJob.class);
        File file = new File(String.valueOf(folder) + "/" + CONFIG_FILE);
        if (file.exists()) {
            this.log.info((Object)("Loading distributed configuration file " + folder + "/" + CONFIG_FILE + "..."));
            PreferenceStore preferenceStore = new PreferenceStore(file);
            preferenceStore.write(this.configuration);
            for (Object key : preferenceStore.getKeys()) {
                this.log.info((Object)("  " + key + ": " + preferenceStore.getString(key.toString())));
            }
        } else {
            this.log.info((Object)"No distributed configuration file (job.config) available.");
        }
    }

    protected void setupDistributedCache(CacheStore cache) throws IOException {
    }

    public abstract void setupJob(Job var1);

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public void set(String name, int value) {
        if (this.canSet) {
            this.configuration.setInt(name, value);
        } else {
            new RuntimeException("Property '" + name + "' couldn't be set. Configuration is looked.");
        }
    }

    public void set(String name, String value) {
        if (this.canSet) {
            this.configuration.set(name, value);
        } else {
            new RuntimeException("Property '" + name + "' couldn't be set. Configuration is looked.");
        }
    }

    public void set(String name, boolean value) {
        if (this.canSet) {
            this.configuration.setBoolean(name, value);
        } else {
            new RuntimeException("Property '" + name + "' couldn't be set. Configuration is looked.");
        }
    }

    public void setInput(String ... inputs) {
        this.inputs = inputs;
    }

    public String[] getInputs() {
        return this.inputs;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getOutput() {
        return this.output;
    }

    public void before() {
    }

    public void after() {
    }

    public void cleanupJob(Job job) {
    }

    public void setJarByClass(Class clazz) {
        this.myClass = clazz;
        this.configuration.setClassLoader(clazz.getClassLoader());
    }

    public void setJar(String jar) {
        this.jar = jar;
    }

    public boolean execute() {
        block18: {
            this.readConfigFile();
            this.log.info((Object)"Setting up Distributed Cache...");
            CacheStore cacheStore = new CacheStore(this.configuration);
            try {
                this.setupDistributedCache(cacheStore);
            }
            catch (Exception e) {
                this.log.error((Object)"Set up Distributed Cache failed.", (Throwable)e);
                return false;
            }
            if (this.jar != null) {
                String temp = HdfsUtil.makeAbsolute(HdfsUtil.path("test", "test.jar")).replace("hdfs://", "");
                HdfsUtil.delete(temp);
                this.log.info((Object)("Copy " + this.jar + " to " + temp + "..."));
                HdfsUtil.put(this.jar, temp);
                try {
                    this.log.info((Object)("Add " + temp + " to classpath..."));
                    cacheStore.addFile(temp);
                    DistributedCache.addFileToClassPath((Path)new Path(temp), (Configuration)this.configuration);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.log.info((Object)"Running Preprocessing...");
            this.before();
            this.job = null;
            this.job = new Job(this.configuration, this.name);
            if (this.myClass != null) {
                this.job.setJarByClass(this.myClass);
            } else {
                this.job.setJarByClass(HadoopJob.class);
            }
            this.log.info((Object)("Creating Job " + this.name + "..."));
            this.canSet = false;
            this.setupJob(this.job);
            try {
                String input;
                String[] stringArray = this.inputs;
                int n = this.inputs.length;
                int e = 0;
                while (e < n) {
                    input = stringArray[e];
                    this.log.info((Object)("  Input Path: " + input));
                    ++e;
                }
                stringArray = this.inputs;
                n = this.inputs.length;
                e = 0;
                while (e < n) {
                    input = stringArray[e];
                    FileInputFormat.addInputPath((Job)this.job, (Path)new Path(input));
                    ++e;
                }
            }
            catch (IOException e) {
                this.log.error((Object)"  Errors setting Input Path: ", (Throwable)e);
            }
            this.log.info((Object)("  Output Path: " + this.output));
            FileOutputFormat.setOutputPath((Job)this.job, (Path)new Path(this.output));
            this.log.info((Object)("Driver jar: " + this.job.getJar()));
            this.log.info((Object)"Running Job...");
            this.job.submit();
            JobClient jobClient = new JobClient(this.getConfiguration());
            while (!this.job.isComplete()) {
                if (this.runningJob == null && this.job.getJobID() != null) {
                    String id = this.job.getJobID().toString();
                    if (jobClient != null) {
                        this.runningJob = jobClient.getJob(id);
                    }
                }
                Thread.sleep(1000L);
            }
            boolean result = this.job.isSuccessful();
            if (!result) break block18;
            this.log.info((Object)"Execution successful.");
            this.log.info((Object)"Running Postprocessing...");
            this.after();
            this.cleanupJob(this.job);
            this.log.info((Object)"Cleanup executed.");
            return true;
        }
        try {
            this.log.info((Object)"Execution failed.");
            this.cleanupJob(this.job);
            this.log.info((Object)"Cleanup executed.");
            return false;
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Execution canceld by user.");
            this.cleanupJob(this.job);
            this.log.info((Object)"Cleanup executed.");
            return false;
        }
        catch (Exception e) {
            this.log.error((Object)"Execution failed.", (Throwable)e);
            this.cleanupJob(this.job);
            this.log.info((Object)"Cleanup executed.");
            return false;
        }
    }

    public void kill() throws IOException, InterruptedException {
        if (!this.job.isComplete()) {
            this.job.killJob();
            while (!this.job.isComplete()) {
                Thread.sleep(100L);
            }
        }
    }

    public String getJobId() {
        if (this.job != null) {
            if (this.job.getJobID() != null) {
                return this.job.getJobID().toString();
            }
            return null;
        }
        return null;
    }

    public void downloadFailedLogs(String folder) {
        this.log.info((Object)"Downloading events...");
        TaskCompletionEvent[] completionEvents = new TaskCompletionEvent[]{};
        try {
            completionEvents = this.runningJob.getTaskCompletionEvents(0);
        }
        catch (Exception e) {
            this.log.error((Object)"Downloading events failed.", (Throwable)e);
            return;
        }
        this.log.info((Object)("Downloaded " + completionEvents.length + " events."));
        this.log.info((Object)("Downloading " + completionEvents.length * 2 + " log files..."));
        TaskCompletionEvent[] taskCompletionEventArray = completionEvents;
        int n = completionEvents.length;
        int n2 = 0;
        while (n2 < n) {
            TaskCompletionEvent taskCompletionEvent = taskCompletionEventArray[n2];
            if (taskCompletionEvent.isMapTask()) {
                BufferedOutputStream out;
                String local;
                BufferedInputStream in;
                HttpURLConnection conn;
                URL url;
                StringBuilder logURL = new StringBuilder(taskCompletionEvent.getTaskTrackerHttp());
                logURL.append("/tasklog?attemptid=");
                logURL.append(taskCompletionEvent.getTaskAttemptId().toString());
                logURL.append("&plaintext=true");
                logURL.append("&filter=" + TaskLog.LogName.STDOUT);
                this.log.info((Object)("Downloading " + logURL + "..."));
                try {
                    url = new URL(logURL.toString());
                    conn = (HttpURLConnection)url.openConnection();
                    in = new BufferedInputStream(conn.getInputStream());
                    local = String.valueOf(folder) + "/" + taskCompletionEvent.getTaskStatus().toString() + "_" + taskCompletionEvent.getTaskAttemptId().toString() + "_stdout.txt";
                    out = new BufferedOutputStream(new FileOutputStream(local));
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                }
                catch (Exception e) {
                    this.log.error((Object)"Downloading log files failed.", (Throwable)e);
                    return;
                }
                logURL = new StringBuilder(taskCompletionEvent.getTaskTrackerHttp());
                logURL.append("/tasklog?attemptid=");
                logURL.append(taskCompletionEvent.getTaskAttemptId().toString());
                logURL.append("&plaintext=true");
                logURL.append("&filter=" + TaskLog.LogName.STDERR);
                this.log.info((Object)("Downloading " + logURL + "..."));
                try {
                    url = new URL(logURL.toString());
                    conn = (HttpURLConnection)url.openConnection();
                    in = new BufferedInputStream(conn.getInputStream());
                    local = String.valueOf(folder) + "/" + taskCompletionEvent.getTaskStatus().toString() + "_" + taskCompletionEvent.getTaskAttemptId().toString() + "_stderr.txt";
                    out = new BufferedOutputStream(new FileOutputStream(local));
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                }
                catch (Exception e) {
                    this.log.error((Object)"Downloading log files failed.", (Throwable)e);
                    return;
                }
            }
            ++n2;
        }
        this.log.info((Object)"Downloading log files successful.");
    }
}

