/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;

public class DistributedHashMap {
    public static String BARCODE = "cloudgene.maps";
    private Configuration configuration;
    private String id;
    private String myBarcode = null;
    private Map<String, String> map = new HashMap<String, String>();

    public DistributedHashMap(String id, Configuration configuration) {
        this.id = id;
        this.configuration = configuration;
        this.myBarcode = String.valueOf(BARCODE) + "." + id + ".";
    }

    public static DistributedHashMap load(String id, Configuration configuration) {
        DistributedHashMap result = new DistributedHashMap(id, configuration);
        Map pairs = configuration.getValByRegex(String.valueOf(result.myBarcode) + "*");
        for (String key : pairs.keySet()) {
            String cleanKey = key.replace(result.myBarcode, "");
            String value = (String)pairs.get(key);
            result.map.put(cleanKey, value);
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public void put(String key, String value) {
        this.map.put(key, value);
        this.configuration.set(String.valueOf(this.myBarcode) + key, value);
    }

    public String get(String key) {
        return this.map.get(key);
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public Collection<String> values() {
        return this.map.values();
    }
}

