/*
 * Decompiled with CFR 0.152.
 */
package genepi.hadoop;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;

public class CacheStore {
    private Configuration conf;

    public CacheStore(Configuration conf) {
        this.conf = conf;
    }

    public String getFile(String name) throws IOException {
        Path[] files = DistributedCache.getLocalCacheFiles((Configuration)this.conf);
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().equals(name)) {
                return files[i].toUri().getPath();
            }
            ++i;
        }
        return null;
    }

    public String getArchive(String key) throws IOException {
        String filename = this.conf.get("distcache-" + key);
        Path[] files = DistributedCache.getLocalCacheArchives((Configuration)this.conf);
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().equals(filename)) {
                return files[i].toUri().getPath();
            }
            ++i;
        }
        return null;
    }

    public void addFile(String filename) {
        URI uri = new Path(filename).toUri();
        DistributedCache.addCacheFile((URI)uri, (Configuration)this.conf);
    }

    public void addArchive(String key, String filename) {
        URI uri = new Path(filename).toUri();
        DistributedCache.addCacheArchive((URI)uri, (Configuration)this.conf);
        Path path = new Path(filename);
        this.conf.set("distcache-" + key, path.getName());
    }
}

