/*
 * Decompiled with CFR 0.152.
 */
package com.github.lindenb.jbwa.jni;

import com.github.lindenb.jbwa.jni.BwaIndex;
import com.github.lindenb.jbwa.jni.BwaMem;
import com.github.lindenb.jbwa.jni.KSeq;
import com.github.lindenb.jbwa.jni.ShortRead;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class Example2 {
    public static void main(String[] args) throws IOException {
        System.loadLibrary("bwajni");
        if (args.length < 3 || args.length >= 4 && !"-v".equals(args[3])) {
            System.out.println("Usage ref.fa fastq1 fasta2 [-v]\n");
            return;
        }
        BwaIndex index = new BwaIndex(new File(args[0]));
        BwaMem mem = new BwaMem(index);
        if (args.length == 4) {
            mem.set_verbosity(4);
        }
        KSeq kseq1 = new KSeq(new File(args[1]));
        KSeq kseq2 = new KSeq(new File(args[2]));
        ArrayList<ShortRead> L1 = new ArrayList<ShortRead>();
        ArrayList<ShortRead> L2 = new ArrayList<ShortRead>();
        while (true) {
            ShortRead read1 = kseq1.next();
            ShortRead read2 = kseq2.next();
            if (read1 == null || read2 == null || L1.size() > 100) {
                if (!L1.isEmpty()) {
                    String[] stringArray = mem.align(L1, L2);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String sam = stringArray[n2];
                        System.out.print(sam);
                        ++n2;
                    }
                }
                if (read1 == null || read2 == null) break;
                L1.clear();
                L2.clear();
            }
            L1.add(read1);
            L2.add(read2);
        }
        kseq1.dispose();
        kseq2.dispose();
        index.close();
        mem.dispose();
    }
}

