#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 

##############
$LSD1_PEAKS    = "/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/MACS2_PEAKS/LSD1_Peaks/LSD1_mES_ChipSeq_2_Young_SRR122470_19_bw1_mm9_Input_Merged_All_q0.05_summits.bed";
$LSD1_BED      = "LSD1_mES_ChipSeq_2_Young_SRR122470_19_bw1_mm9_Input_Merged_All_q0.05_300bp.bed";
system ("mkdir FASTAs");
############ CONVERT LSD1 SUMMITS TO BED ############ 
open (LSD1_SUMMITS,"$LSD1_PEAKS");
open (LSD1_PEAK_BED_300,">$LSD1_BED");
$nP=0;
while ($line=<LSD1_SUMMITS>)
{
	$nP++;	
	chomp $line;
	@INFO=split("\t",$line);
	$CHR   = $INFO[0];
	$LEFT  = $INFO[1]-150;
	$RIGHT = $INFO[2]+150;
	print LSD1_PEAK_BED_300 "$CHR\t$LEFT\t$RIGHT\tLSD1_PEAK_$nP\n";
}
close LSD1_PEAK_BED_300;
close LSD1_SUMMITS;
############ CONVERT LSD1 SUMMITS TO BED ############ 
$GENIC_REGION  = "/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/DHS_SITES_INTERGENIC/KNOWN_GENES_1250Up_to_3000Down_REFGENE_mm9_BED.bed";
$ENHANCER_LIST = "/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/GROSEQ_EXPRESSION_CHANGE/DESEQ/GET_DE_ENHANCERS/ALL_ENHANCERS.bed";
$SIG_ENHANCERS = "/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/GROSEQ_EXPRESSION_CHANGE/DESEQ/GET_DE_ENHANCERS/Significantly_Changed_ALL_ENHANCERS_0.05.bed";
system ("wc -l $LSD1_PEAKS $GENIC_REGION $ENHANCER_LIST $SIG_ENHANCERS");

system ("cat $SIG_ENHANCERS |grep SIG_UP   > Significantly_Upregulated_Enhancers.bed");
system ("cat $SIG_ENHANCERS |grep SIG_DOWN > Significantly_Downregulated_Enhancers.bed");

system ("bedtools intersect -wa -v -a $LSD1_BED -b $GENIC_REGION                             > LSD1_PEAKS_INTERGENIC.bed");
system ("bedtools intersect -wa -u -a $LSD1_BED -b $ENHANCER_LIST                            > ALL_ENHANCERS_LSD1_PEAKS.bed");
system ("bedtools intersect -wa -u -a $LSD1_BED -b Significantly_Upregulated_Enhancers.bed   >   SIGUP_ENHANCERS_LSD1_PEAKS.bed");
system ("bedtools intersect -wa -u -a $LSD1_BED -b Significantly_Downregulated_Enhancers.bed > SIGDOWN_ENHANCERS_LSD1_PEAKS.bed");

system ("wc -l *.bed; sleep 3");

#####################################################
$FINDMOTIFSGENOME="/home/saurabha/UTILITIES/HOMER/HOMER/bin/findMotifsGenome.pl";
@SAMPLES=qw(LSD1_PEAKS_INTERGENIC ALL_ENHANCERS_LSD1_PEAKS SIGUP_ENHANCERS_LSD1_PEAKS SIGDOWN_ENHANCERS_LSD1_PEAKS);

for $x (0 .. $#SAMPLES)
{
$SAMPLE=$SAMPLES[$x];
print "$x\t$SAMPLE",`wc -l $SAMPLE.bed`,"\n";
system ("$FINDMOTIFSGENOME $SAMPLE.bed mm9 MOTIFS_$SAMPLE -keepFiles -p 4 &");
system ("bedtools getfasta -name -fi /scratch/iwase-lab/SAURABH/GENOMES/MM9/mm9.fa -bed $SAMPLE.bed -fo FASTAs/$SAMPLE.fa");
sleep 10;
}



