#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor;
use List::Util qw(min max);
##############################

#########################################
$FOLDER="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/Active_Vs_Poised/Classify";

@FILES=qw(
ACTIVE_vs_POISED_mES_Enhancers
LSD1_BOUND_ACTIVE_vs_POISED_mES_Enhancers
LSD1_UNBOUND_ACTIVE_vs_POISED_mES_Enhancers);

for $x (0 .. 2)
{
$LIST=$FILES[$x];
open (ENHANCER_INFO,"cat $FOLDER/$LIST.txt |grep -v ENHANCER_ID|");
open (ENHANCER_BED,">$LIST.bed");
$LN=0;
print " Now Doing $LIST\n";
while ($line = <ENHANCER_INFO>)
{
	chomp $line;
	@INFO=split("\t",$line);
	($NAME,$CHR,$CENTER)=split(":::",$INFO[0]);
	$LEFT  = $CENTER-300;
	$RIGHT = $CENTER+300;
	print ENHANCER_BED "$CHR\t$LEFT\t$RIGHT\t$INFO[0]\n";
}
close ENHANCER_BED;
close ENHANCER_INFO;

system ("bedtools getfasta -name -fi /scratch/iwase-lab/SAURABH/GENOMES/MM9/mm9.fa -bed $LIST.bed -fo $LIST.fa");
}
#########################################
print "NOW FINDING MOTIFS\n";

@MOTIFS_TO_SEARCH=qw(
CTCFL_MOUSE.H11MO.0.A
CTCF_MOUSE.H11MO.0.A
ESR1_MOUSE.H11MO.1.A
ESR2_MOUSE.H11MO.0.A
FOXA1_MOUSE.H11MO.0.A
FOXA2_MOUSE.H11MO.0.A
FOXD1_MOUSE.H11MO.0.D
FOXD3_MOUSE.H11MO.0.C
GATA2_MOUSE.H11MO.0.A
HMGA2_MOUSE.H11MO.0.D
HNF4A_MOUSE.H11MO.0.A
KLF4_MOUSE.H11MO.0.A
NANOG_MOUSE.H11MO.0.A
NANOG_MOUSE.H11MO.1.A
NR5A2_MOUSE.H11MO.0.A
PO5F1_MOUSE.H11MO.0.A
PO5F1_MOUSE.H11MO.1.A
REST_MOUSE.H11MO.0.A
SOX2_MOUSE.H11MO.0.A
SOX2_MOUSE.H11MO.1.A
);

$fimo="/home/saurabha/UTILITIES/MEME/meme/bin/fimo";
$MOTIF_DATABASE="/home/saurabha/UTILITIES/MEME/meme/db/motif_databases/MOUSE/HOCOMOCOv11_full_MOUSE_mono_meme_format.meme";

for $x (0 .. $#MOTIFS_TO_SEARCH)
{
	$MOTIF=$MOTIFS_TO_SEARCH[$x];
	print color ("yellow"), "#$x $MOTIF\t";
	system ("$fimo --verbosity 1 --bgfile mm9-meme-bg.txt --motif $MOTIF --o $MOTIF $MOTIF_DATABASE LSD1_UNBOUND_ACTIVE_vs_POISED_mES_Enhancers.fa");
	($TOTAL_HITS,$FILENAME)=split (" ",`wc -l $MOTIF/fimo.txt`);
	$Number_Of_Hits = `cat $MOTIF/fimo.txt |tr -s '\s' '\t'|cut -f2 |sort |uniq|wc -l`;
	print color ("cyan"), "TOTAL MOTIF HITS =$TOTAL_HITS UNIQUE HITS =$Number_Of_Hits ";
}

