#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 
system ("rm BOWTIE_GROSEQ_STATUS.txt POLYA_ADAPTER.fa; ls -l; sleep 3");

open (STDERR, '>BOWTIE_GROSEQ_STATUS.txt');

$BOWTIE="/home/saurabha/MAPPING_SOFTWARES/BOWTIE_1/BOWTIE_112/bin/bowtie";
$BOWTIE_1_MM9_INDEX = '/scratch/iwase-lab/SAURABH/GENOME_INDICES/MM9/MM9_BOWTIE_1/mm9_bowtie112';
$MM9_FA_Fai="/scratch/iwase-lab/SAURABH/GENOMES/MM9/mm9.fa.fai";
$FOLDER = '/mnt/iwase/AGARWAL/LSD1_RNASEQ_FILES_FROM_PROMOTER/GROSEQ/FASTQ_FILES';

open (ADAPTER_FASTA,">POLYA_ADAPTER.fa");
print ADAPTER_FASTA ">adapter_1\nAAAAAAAAAAAAAAAAAAAAGATCGGAAGAGCACACGTCTGAACTCCAGT\n";
print ADAPTER_FASTA ">adapter_2\nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA\n";
close ADAPTER_FASTA;

system ("cat POLYA_ADAPTER.fa; sleep 5");
print "\n\n";

open (LANE_INFO, "<GROSEQ_mES_LANE_INFO.txt") or die "couldn't open $infilename, $!\n";
$x=0;
while ($line=<LANE_INFO>)
{
$x++;
chomp $line;
($SAMPLE, $FASTQ) = split(/\t/,$line);
system ("ls -lh $FOLDER/$FASTQ");
################################# INITIAL BOWTIE 50bp #################################
$ROOT=$SAMPLE."_bowtie1_mm9";
print color ("yellow"), "\n\n###### $x Doing $SAMPLE \t $ROOT ######\n", color ("reset");  
print STDERR "\n\n###### $x Doing $SAMPLE \t $ROOT ######\n";  

$ROOT_MAPPED_FL  = "Mapped_FL_$ROOT.bam";
$ROOT_UNMAPPED_FL  = "Unmapped_FL_$ROOT.fastq";
$BBDUK_UNMAPPED_FASTQ  = "BBDUK_Trimmed_$ROOT.fastq.gz";

$ROOT_MAPPED_TRIMMED  = "Mapped_BBDUK_Trimmed_$ROOT.bam";
$ROOT_UNMAPPED_TRIMMED  = "Unmapped_BBDUK_Trimmed_$ROOT.fastq";

print        "$ROOT_MAPPED_FL\t$ROOT_UNMAPPED_FL\n$ROOT_UNMAPPED_BBDUK\n$ROOT_MAPPED_TRIMMED\t$ROOT_UNMAPPED_TRIMMED\n";
print STDERR "$ROOT_MAPPED_FL\t$ROOT_UNMAPPED_FL\n$ROOT_UNMAPPED_BBDUK\n$ROOT_MAPPED_TRIMMED\t$ROOT_UNMAPPED_TRIMMED\n";

$iOPTIONS = "-v 3 -m 1 --best --strata -S --sam-nohead --sam-nosq --time -p 18 --un $ROOT_UNMAPPED_FL";
$COMMAND="bzip2 -cd $FOLDER/$FASTQ| $BOWTIE $iOPTIONS $BOWTIE_1_MM9_INDEX - | samtools view -F 0x4 -S -b -t $MM9_FA_Fai -o - -> $ROOT_MAPPED_FL";

print        "Full Length OPTIONS= $iOPTIONS\nCOMMAND=$COMMAND\n"; print STDERR "Full Length OPTIONS= $iOPTIONS\nCOMMAND=$COMMAND\n";

system("$COMMAND");

print STDERR scalar localtime; print STDERR " FIRST BOWTIE FINISHED ON $x $ROOT\n$SAMPLE\n$FASTQ\n";
############################# REMOVING PolyA Tail with BBDUK #############################
$BBDUK_WITH_OPTIONS="/home/saurabha/UTILITIES/BBTools/bbmap/bbduk.sh -Xmx4g ktrim=r mink=1 minlength=15 hdist=2 rcomp=f qtrim=rl trimq=10 ref=POLYA_ADAPTER.fa";
$BBDUK_COMMAND="$BBDUK_WITH_OPTIONS in=$ROOT_UNMAPPED_FL  out=$BBDUK_UNMAPPED_FASTQ";
print "\n$BBDUK_COMMAND\n"; print STDERR "\n$BBDUK_COMMAND\n";

system ("$BBDUK_COMMAND");

################################# BOWTIE ON BBDUK TRIMMED READS #################################
$OPTIONS = "-v 2 -m 1 --best --strata -S --sam-nohead --sam-nosq --time -p 18"; # --un $ROOT_UNMAPPED_TRIMMED";
$BOWTIE_ON_TRIMMED_COMMAND="gzip -cd $BBDUK_UNMAPPED_FASTQ| $BOWTIE $OPTIONS $BOWTIE_1_MM9_INDEX - | samtools view -F 0x4 -S -b -t $MM9_FA_Fai -o - -> $ROOT_MAPPED_TRIMMED";
print       "$BOWTIE_ON_TRIMMED_COMMAND\n";
print STDERR"$BOWTIE_ON_TRIMMED_COMMAND\n";

system("$BOWTIE_ON_TRIMMED_COMMAND");
print STDERR scalar localtime, " SECOND BOWTIE FINISHED ON $x $ROOT\n$SAMPLE\n$FASTQ\n\n\n";

system ("samtools merge -@ 6 -rf $ROOT.bam $ROOT_MAPPED_FL $ROOT_MAPPED_TRIMMED");
system ("samtools sort -@ 6 -m 32G $ROOT.bam -o Sorted_$ROOT.bam");
system ("samtools index Sorted_$ROOT.bam");
sleep 3;
system ("rm $ROOT.bam $ROOT_MAPPED_FL $ROOT_MAPPED_TRIMMED");
system ("rm $ROOT_UNMAPPED_FL $BBDUK_UNMAPPED_FASTQ");# $ROOT_UNMAPPED_TRIMMED");

print color ("green"),  scalar localtime, " $x $ROOT\nMerged Sorted and Indexed $SAMPLE\n$FASTQ\n\n\n",color("reset");
print STDERR scalar localtime, " $x $ROOT\nMerged Sorted and Indexed $SAMPLE\n$FASTQ\n\n\n";
sleep 1;
}

close LANE_INFO;
print STDERR scalar localtime; print STDERR " BOWTIE FINISHED ON ALL Without failure:-) \n";
close(STDERR);
