#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 
system ("rm READ_COUNTS.txt; ls -l; sleep 3");
system ("echo date STARTING > READ_COUNTS.txt");

open (STDERR, '>BOWTIE_GROSEQ_STATUS.txt');

$FOLDER = '/scratch/iwase-lab/SAURABH/GROSEQ_ANALYSIS_NEW/MAPPING/BBDUK';

open (LANE_INFO, "<MERGE_LIST_GROSEQ.txt") or die "couldn't open LANE_INFO";

while ($line=<LANE_INFO>)
{
$x++;
chomp $line;
($NAME, $SUFFIX) = split(/\t/,$line);

$MERGED_FILE="Merged_$NAME"."_B1B2".$SUFFIX;
$FILE_B1="$FOLDER/Sorted_$NAME"."_B1".$SUFFIX;
$FILE_B2="$FOLDER/Sorted_$NAME"."_B2".$SUFFIX;

print color ("yellow"), "###### $x $NAME\t\t$SUFFIX\n$MERGED_FILE\n$FILE_B1\n$FILE_B2\n\n", color("reset");

system ("ls -l $FILE_B1 $FILE_B2");

$MERGE_COMMAND="samtools merge -u -rf - $FILE_B1 $FILE_B2 | samtools sort -@ 6 -m 64G - -o $MERGED_FILE";
print color("yellow"), "MERGE_COMMAND=\n$MERGE_COMMAND\n";
print STDERR "$MERGE_COMMAND\n"; 

system ("$MERGE_COMMAND");

print color ("green"), "###### $x $MERGED_FILE Merged !!!\n\n", color("reset");
print STDERR scalar localtime, " $x $NAME\nMerged Sorted and Indexed $NAME\t$SUFFIX\n$MERGED_FILE\n";

$BAMFILE=$MERGED_FILE;

system("ls -l $BAMFILE");
system ("samtools index $BAMFILE");
sleep 3;
system ("echo $BAMFILE>> READ_COUNTS.txt");
system ("echo Total >> READ_COUNTS.txt");
system("samtools view -c $BAMFILE >> READ_COUNTS.txt");
system ("echo Ribosomal >> READ_COUNTS.txt");
system("samtools view -c $BAMFILE chr17:39978942-39986774 >> READ_COUNTS.txt");
system ("echo Mitochondrial >> READ_COUNTS.txt");
system("samtools view -c $BAMFILE chrM >> READ_COUNTS.txt");
print color ("green"), "###### $x READ COUNTING DONE ON $MERGED_FILE\n\n\n\n", color("reset");
sleep 3;
}
close LANE_INFO;
##################

open (COUNTS,"<READ_COUNTS.txt");
open (FORMATTED,">Formatted_READ_COUNTS.txt");
while ($line = <COUNTS>)
{
chomp $line;
if ($line eq "date STARTING") {next;}
if (index($line,"_GROSEQ_") > -1) {print FORMATTED "\n$line\t";}
if (index($line,"_GROSEQ_") < 0) {print FORMATTED "$line\t";}
}
close COUNTS;
close FORMATTED;

##################

open (COUNTS,"<Formatted_READ_COUNTS.txt");
open (FORMATTED,">READ_SUMMARY.txt");

while ($line = <COUNTS>)
{
chomp $line;
if ($line eq "") {next;}
($SAMPLE,$T, $TOTAL, $R, $rRNA, $M, $mtRNA)=split("\t",$line);
$GOOD_READS=$TOTAL - $rRNA - $mtRNA;

$NORM_FACTOR          =sprintf("%.6f", 10000000/$GOOD_READS);
$rRNA_PERCENTAGE      =sprintf("%.2f", $rRNA*100/$TOTAL);
$mtRNA_PERCENTAGE     =sprintf("%.2f", $mtRNA*100/$TOTAL);
$PERCENTAGE_GOOD_READS=sprintf("%.3f", $GOOD_READS*100/$TOTAL);

print FORMATTED "$SAMPLE\t$TOTAL\t$R\t$rRNA\t$rRNA_PERCENTAGE %\t$M\t$mtRNA\t$mtRNA_PERCENTAGE %\t$GOOD_READS\t$PERCENTAGE_GOOD_READS %\t$NORM_FACTOR\n";
}
close COUNTS;
close FORMATTED;

print "Counting Reads Done !!!\nCounting Reads Done !!!\nCounting Reads Done !!!\n";


print STDERR scalar localtime; print STDERR " MERGING FINISHED ON ALL Without failure:-) \n";
close(STDERR);
