#!/usr/bin/env Rscript
library(scales)

args <- commandArgs(trailingOnly=TRUE)
print(args)

DESEQ <-as.matrix(read.table(args[1],header=FALSE,dec = "."))
WT <- as.numeric(DESEQ[,1])
KO <- as.numeric(DESEQ[,2])
COL  <- DESEQ[,3]
ALPHA<-as.numeric(DESEQ[,4])
CEX  <- as.numeric(DESEQ[,5])

png(file=args[2],width=1500,height=1470)

plot(WT, KO, col=alpha(COL,ALPHA), cex=CEX, ylim=c(-4,4), xlim=c(-4,4), pch=16, xaxs="i", asp=1, las=2,xlab="",ylab="" )
#lines(x = c(-4,4), y = c(-4,4), lty=5, lwd=2)
lines(x = c(-4,4), y = c(0,0), lty=5, lwd=2)
lines(x = c(0,0), y = c(-4,4), lty=5, lwd=2)
abline(lm(KO~WT), col="black", lwd=3)

CORREL <-cor.test(WT, KO, method = "pearson")
CORREL


SIGFILE <- paste("SIG_",args[1],sep = "")
SIG <-as.matrix(read.table(SIGFILE,header=FALSE,dec = "."))
SIG_1 <- as.numeric(SIG[,1])
SIG_2 <- as.numeric(SIG[,2])
CORREL <-cor.test(SIG_1, SIG_2, method = "pearson")
CORREL
abline(lm(SIG_2~SIG_1), col="mediumorchid4", lwd=4)



