#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 
print "\n\n\n";
system ("ls -l; sleep 5");

##############################
##############################
$SAMPLE_FOLDER="/mnt/promoter1/home/saurabh/LSD1_GENOME_RESEARCH/BOWTIE_MAPPING_1_50";

@SAMPLES=qw(
H3K4me2_0h
H3K4me2_24h
LSD1_0h 
LSD1_24h 
MLL4_0h 
MLL4_24h 
);

######### COPYING INPUT TO Shared Memory ######### 
$INPUT_HD = "$SAMPLE_FOLDER/Input_50bp_mm9.bam";
$INPUT    = "/dev/shm/Input_50bp_mm9.bam";

system ("rm $INPUT; sleep 5; ls -l /dev/shm");
system ("cp -pvf $INPUT_HD /dev/shm/");
sleep 5;
system ("ls -l $INPUT");

############################
open (STDERR,">MACS2_PEAK_CALLING_STATUS.txt");

for $s (0 .. $#SAMPLES)
{
$NAME = $SAMPLES[$s];
$BAMFILE = "$SAMPLE_FOLDER/$NAME"."_50bp_mm9.bam";
$CHAR = "&"; if (($s eq 2) || ($s eq 5) || ($s eq 8)) {$CHAR = "";} 

print STDERR  "Now Doing $s\t$NAME\n$BAMFILE\n";
print color ("yellow"), scalar localtime, "\n\n\nDoing $s\t$NAME\n$BAMFILE\n", color("reset"); 
system ("ls -l $BAMFILE $INPUT");

####################
$SAMPLE      =  $NAME."_mm9_q0.05";
$CALL_PEAKS  = "/usr/bin/macs2 callpeak -f BAM -g 1.87e9 -q 0.05 -t $BAMFILE -c $INPUT -n $SAMPLE";
print        "$CALL_PEAKS\n"; print STDERR "$CALL_PEAKS\n";
system      ("$CALL_PEAKS &");
sleep 15; 

$SAMPLE      =  $NAME."_mm9_p0.01";
$CALL_PEAKS  = "/usr/bin/macs2 callpeak -f BAM -g 1.87e9 -p 0.01 -t $BAMFILE -c $INPUT -n $SAMPLE";
print        "$CALL_PEAKS\n"; print STDERR "$CALL_PEAKS\n";
system      ("$CALL_PEAKS &");
sleep 15; 

$SAMPLE      =  $NAME."_broad_mm9_q0.05";
$CALL_PEAKS  = "/usr/bin/macs2 callpeak -f BAM -g 1.87e9 -q 0.05 --broad -t $BAMFILE -c $INPUT -n $SAMPLE";
print        "$CALL_PEAKS\n"; print STDERR "$CALL_PEAKS\n";
system      ("$CALL_PEAKS &");
sleep 15; 

$SAMPLE      =  $NAME."_broad_mm9_p0.01";
$CALL_PEAKS  = "/usr/bin/macs2 callpeak -f BAM -g 1.87e9 -p 0.01 --broad -t $BAMFILE -c $INPUT -n $SAMPLE";
print        "$CALL_PEAKS\n"; print STDERR "$CALL_PEAKS\n";
system      ("$CALL_PEAKS $CHAR");
sleep 15; 
}

#close STDERR;

print color ("green"), "All Done !!!\nAll Done !!!\nAll Done !!!\nAll Done !!!\nAll Done !!!\n";

