#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 

system ("rm *.bed *.narrowPeak; ls -l; sleep 3");


@SAMPLES=qw(
NONE
H3K4me2_0h 
H3K4me2_24h 
LSD1_0h 
LSD1_24h 
MLL4_0h 
MLL4_24h 
Input 
);

@COMBINATIONS=qw(1X2 3X4 5X6);

################## RUNNING DESEQ ON EACH COMBINATIONS ##################
for $C (0 .. $#COMBINATIONS)
{
($SAMPLE_NUM_1,$SAMPLE_NUM_2)=split("X",$COMBINATIONS[$C]);

$SAMPLE_1=$SAMPLES[$SAMPLE_NUM_1];
$SAMPLE_2=$SAMPLES[$SAMPLE_NUM_2];

$FOLDER = "/mnt/promoter1/home/saurabh/LSD1_GENOME_RESEARCH/ANALYSIS_AT_ALL_MACS2_PEAKS/READ_COUNTS";
$COUNT_FILE_1="$FOLDER/$SAMPLE_1.counts";
$COUNT_FILE_2="$FOLDER/$SAMPLE_2.counts";

$MERGED = $SAMPLE_1."_vs_".$SAMPLE_2;
$MERGED_COUNTS = "FOR_DESEQ_CHIPSEQ_$MERGED.counts";
$MERGED_OUTPUT_1   = "DESEQ_RAW_$MERGED.txt";
$MERGED_OUTPUT_2   = "DESEQ_$MERGED.txt";

print "$C Now Creating $C $MERGED_COUNTS\n";

system ("paste $COUNT_FILE_1 $COUNT_FILE_2|wc -l");

open (INPUT_COUNTS  ,"paste $COUNT_FILE_1 $COUNT_FILE_2|");
open ($MERGED_COUNTS,">$MERGED_COUNTS");

while ($line=<INPUT_COUNTS>)
{
chomp $line;
@DATA=split("\t",$line);
if ($DATA[0] ne $DATA[2]) {print color("red"), "IDs do not match\n";die;}
print $MERGED_COUNTS "$DATA[0]\t$DATA[1]\t$DATA[3]\n";
}
close $MERGED_COUNTS;
close INPUT_COUNTS;
system ("Rscript DESEQ_CHIPSEQ.R $SAMPLE_1 $SAMPLE_2 $MERGED_COUNTS $MERGED_OUTPUT_1");

######### CALCULATE LOG2FOLDCHANGE WITH +1 READCOUNT #########
open(DESEQ_IN,"$MERGED_OUTPUT_1");
open(DESEQ_OUT,">$MERGED_OUTPUT_2");

while ($line=<DESEQ_IN>)
{
chomp $line;
($ln,$id,$baseMean,$baseMeanA,$baseMeanB,$foldChange,$log2FoldChange,$pval,$padj)=split("\t",$line);
if ($ln eq "") {}
if ($ln ne "") 
	{
	($PEAK_NUM,$C,$L,$R)=split(":::",$id);
	$log2FoldChange=log(($baseMeanB+1)/($baseMeanA+1))/log(2);
	$ID=$id.":::".$log2FoldChange.":::".$pval;
	print DESEQ_OUT "$C\t$L\t$R\t$ID\t.\t.\n";
	}
}
close DESEQ_IN;
close DESEQ_OUT;
$COMMAND = "bedtools intersect -wa -v -a $MERGED_OUTPUT_2 -b ../1250bp_AROUND_PROMOTERS.bed |cut -f 4|awk '{print \$1,\$2,\$3,\$4,\$5,\$6}' FS=':::' OFS='\t' > Promoter_Distal_$MERGED_OUTPUT_2";
system("$COMMAND");
$COMMAND = "bedtools intersect -wa -u -a $MERGED_OUTPUT_2 -b ../1250bp_AROUND_PROMOTERS.bed |cut -f 4|awk '{print \$1,\$2,\$3,\$4,\$5,\$6}' FS=':::' OFS='\t' > Promoter_Proximal_$MERGED_OUTPUT_2";
system("$COMMAND");

system ("head  $MERGED_OUTPUT_2 Promoter_Distal_$MERGED_OUTPUT_2 Promoter_Proximal_$MERGED_OUTPUT_2");
system ("wc -l $MERGED_OUTPUT_2 Promoter_Distal_$MERGED_OUTPUT_2 Promoter_Proximal_$MERGED_OUTPUT_2");

}

