#!/usr/bin/env Rscript

args <- commandArgs(trailingOnly=TRUE)
print(args)

COUNTS = read.table(args[3],header=TRUE,sep="\t",row.names=1)
head (COUNTS)

DESIGN = data.frame(row.names = colnames(COUNTS), condition = c(args[1],args[2]), libType = c("single-end", "single-end"))
DESIGN

SAMPLES = DESIGN$libType == "single-end"
countTable = COUNTS[ , SAMPLES]
condition = DESIGN$condition[ SAMPLES]
condition

library( "DESeq" )

cds = newCountDataSet( countTable, condition )
cds = estimateSizeFactors( cds )
sizeFactors( cds )

head( counts( cds, normalized=TRUE ) )

cds = estimateDispersions( cds, method="blind", sharingMode = "fit-only")

res = nbinomTest( cds, args[1],args[2])

head(res)
plotMA(res)
write.table( res, file=args[4], quote=FALSE, sep='\t', col.names = NA )

str( fitInfo(cds) )
plotDispEsts( cds )



