#!/usr/bin/env Rscript

COUNTS = read.table("../Selected_LSD1_KD_CN_BRUSEQ",header=TRUE,sep="\t",row.names=1)
head (COUNTS)

DESIGN = data.frame(row.names = colnames(COUNTS), condition = c("UNTREATED","UNTREATED","CONTROL","CONTROL","shRNA_A","shRNA_A","shRNA_B","shRNA_B"), libType = c("single-end", "single-end","single-end", "single-end","single-end", "single-end","single-end", "single-end"))
DESIGN

SAMPLES = DESIGN$libType == "single-end"
countTable = COUNTS[ , SAMPLES]
condition = DESIGN$condition[ SAMPLES]
condition

library( "DESeq" )

cds = newCountDataSet( countTable, condition )
cds = estimateSizeFactors( cds )
sizeFactors( cds )

head( counts( cds, normalized=TRUE ) )

cds = estimateDispersions( cds)

#######################################
PAIR1 = nbinomTest( cds, "UNTREATED","CONTROL")
head(PAIR1)
write.table(PAIR1, file="DESEQ_PAIR1_UNTREATED_v_CONTROL.txt", quote=FALSE, sep='\t', col.names = NA )

PAIR2 = nbinomTest( cds, "UNTREATED","shRNA_A")
head(PAIR2)
write.table(PAIR2, file="DESEQ_PAIR2_UNTREATED_v_shRNA_A.txt", quote=FALSE, sep='\t', col.names = NA )

PAIR3 = nbinomTest( cds, "UNTREATED","shRNA_B")
head(PAIR3)
write.table(PAIR3, file="DESEQ_PAIR3_UNTREATED_v_shRNA_B.txt", quote=FALSE, sep='\t', col.names = NA )
#######################################
PAIR4 = nbinomTest( cds, "CONTROL","shRNA_A")
head(PAIR4)
write.table(PAIR4, file="DESEQ_PAIR4_CONTROL_v_shRNA_A.txt", quote=FALSE, sep='\t', col.names = NA )

PAIR5 = nbinomTest( cds, "CONTROL","shRNA_B")
head(PAIR5)
write.table(PAIR5, file="DESEQ_PAIR5_CONTROL_v_shRNA_B.txt", quote=FALSE, sep='\t', col.names = NA )



