#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 

system ("rm TOPHAT_STATUS.txt");
system ("rm -rf BBDUK_FASTQs TOPHAT_FINISHED_AND_MERGED_BAM_FILES");
print color ("reset"), "\n\n\n"; sleep 1; 
system ("ls -l");

open (STDERR,">TOPHAT_STATUS.txt");
system ("mkdir BBDUK_FASTQs TOPHAT_FINISHED_AND_MERGED_BAM_FILES");

#######
$BBDUK_WITH_OPTIONS="/home/saurabha/UTILITIES/BBTools/bbmap/bbduk.sh -Xmx2g showspeed=t ktrim=r k=30 mink=2 minlength=20 hdist=1";

open (ADAPTER_FASTA,">DLAR_ADAPTER.fa");
print ADAPTER_FASTA ">adapter\nCATAGGAAGAGCACACGTCTGAACTCCAGTCAC\n";
close ADAPTER_FASTA;
system ("cat DLAR_ADAPTER.fa");
print "\n\n";

#######
$GENOME="mm9";
$GENOME_FOLDER="/scratch/iwase-lab/SAURABH/GENOMES/MM9";
$GENOME_FASTA="$GENOME_FOLDER/mm9.fa";
$GENOME_FaFai="$GENOME_FOLDER/mm9.fa.fai";
$GENOME_CHROM_SIZES="$GENOME_FOLDER/mm9.chrom.sizes";
$GENE_ANNOTATION="/scratch/iwase-lab/SAURABH/ANNOTATIONS/MM9/archive-2014-05-23-16-05-24/Genes/genes_mm9.gtf";
$GENOME_INDEX="/scratch/iwase-lab/SAURABH/GENOME_INDICES/MM9/MM9_BOWTIE_2/mm9_bowtie226";
$JUNCTION_FILE="/scratch/iwase-lab/SAURABH/BRUSEQ_ANALYSIS/BRUSEQ_LSD1_CN_RUN_1/Sorted_mm9_merged_junctions.junc";
#######
$TOPHAT="/home/saurabha/MAPPING_SOFTWARES/TOPHAT_2/TOPHAT_210/bin/tophat";
$OPTIONS = "-g 1 --GTF=$GENE_ANNOTATION -p 12 --no-coverage-search -j $JUNCTION_FILE";

$SAMPLE_FOLDER="/scratch/iwase-lab/SAURABH/RAW_DATA_NEW/TUFTS/LSD1_KD_CN_BRUSEQ";
@SAMPLES=qw(Pool2-DLAR_CN_shRNA_A2_S6_L002_R1_001 Pool2-DLAR_CN_shRNA_B2_S8_L002_R1_001 Pool2-DLAR_CN_shRNA_Control_2_S7_L002_R1_001 Pool2-DLAR_CN_Untreated_2_S5_L002_R1_001 Pool3-DLAR_CN_shRNA_A3_S2_L001_R1_001 Pool3-DLAR_CN_shRNA_B3_S4_L001_R1_001 Pool3-DLAR_CN_shRNA_Control_3_S3_L001_R1_001 Pool3-DLAR_CN_Untreated_3_S1_L001_R1_001 Undetermined_S0_L001_R1_001 Undetermined_S0_L002_R1_001);

$SUFFIX=$GENOME."_TOPHAT_bw2";
$TRANSCRIPTOME_INDEX="TRANSCRIPTOME_INDEX_$SUFFIX/transcriptome_$SUFFIX";

for $x (0 .. $#SAMPLES)
{
$sample="";$root="";$FASTQ="";
$sample=$SAMPLES[$x];
$root=$sample."_$SUFFIX";
$FASTQ="$SAMPLE_FOLDER/$sample.fastq.gz";

print color("yellow"), "\n################################### $x $root $FASTQ ###################################\n";
system ("ls -lh $FASTQ");

###### STEP 1 TOPHAT RUN 1 #######
$TOPHAT_COMMAND_1="$TOPHAT $OPTIONS --transcriptome-index=$TRANSCRIPTOME_INDEX --tmp-dir=temp_$root --output-dir=$root $GENOME_INDEX $FASTQ";

print color ("red"), scalar localtime, "$TOPHAT_COMMAND_1\n";
print STDERR         scalar localtime, "$TOPHAT_COMMAND_1\n";

system("module load boost/1.57.0; sleep 3; $TOPHAT_COMMAND_1"); 
print STDERR           scalar localtime, " TOPHAT FINISHED ON $root\n$READS\n";
print color ("green"), scalar localtime, " TOPHAT FINISHED ON $root\n$READS\n#######################\n\n", color ("reset");


####### ADAPTER TRIMMING USING BBDUK ######
$BBDUK_FASTQ="BBDUK_FASTQs/BBDUK_$root.fastq.gz";
$BBDUK_COMMAND="$BBDUK_WITH_OPTIONS in=$root/unmapped.bam ref=DLAR_ADAPTER.fa out=$BBDUK_FASTQ";
print color ("red"), scalar localtime, "$BBDUK_COMMAND\n";
print STDERR         scalar localtime, "$BBDUK_COMMAND\n";
system ("$BBDUK_COMMAND");
system ("ls -lh $BBDUK_FASTQ");

###### STEP 3 TOPHAT RUN 2 #######
$TOPHAT_COMMAND_2="$TOPHAT $OPTIONS --transcriptome-index=$TRANSCRIPTOME_INDEX --tmp-dir=temp_BBDUK_$root --output-dir=BBDUK_$root $GENOME_INDEX $BBDUK_FASTQ";

print color ("red"), scalar localtime, "$TOPHAT_COMMAND_2\n";
print STDERR         scalar localtime, "$TOPHAT_COMMAND_2\n";

system("module load boost/1.57.0; sleep 3; $TOPHAT_COMMAND_2"); 
print STDERR            scalar localtime, " TOPHAT RUN 2 FINISHED ON BBDUK_$root $BBDUK_FASTQ\n";
print color ("yellow"), scalar localtime, " TOPHAT RUN 2 FINISHED ON BBDUK_$root\n$BBDUK_FASTQ\n#######################\n\n", color ("reset");

system ("samtools merge -rf -@ 8 TOPHAT_FINISHED_AND_MERGED_BAM_FILES/Merged_$root.bam $root/accepted_hits.bam BBDUK_$root/accepted_hits.bam");
print color ("green"), scalar localtime, "$x TOPHAT RUNS FINISHED ON $root AND Files Merged !!!\n\n\n";
print STDERR           scalar localtime, "$x TOPHAT RUNS FINISHED ON $root AND Files Merged !!!\n\n\n #############################\n\n";
sleep 5;
system ("mv $root/accepted_hits.bam TOPHAT_FINISHED_AND_MERGED_BAM_FILES/$root.bam");
system ("mv BBDUK_$root/accepted_hits.bam TOPHAT_FINISHED_AND_MERGED_BAM_FILES/BBDUK_$root.bam");
sleep 3;
}

print STDERR scalar localtime; print STDERR " TOPHAT FINISHED ON ALL Without failure:-) \n";
close(STDERR);

