#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 
##################
system ("rm *.bedgraph *.bw *.txt; ls -l");
open (STDERR,">BAM_TO_BW_STATUS.txt");
open (HEADER,">HEADER_BAM_TO_BW.txt");

$MM9_CHROM_SIZES="/scratch/iwase-lab/SAURABH/GENOMES/MM9/mm9.chrom.sizes";
$BEDTOOLS_GENOME_COVERAGE="/home/saurabha/UTILITIES/BEDTOOLS/BEDTOOLS_2/bin/genomeCoverageBed";

$WigToBigWig="/scratch/iwase-lab/SAURABH/BRUSEQ_ANALYSIS/BRUSEQ_LSD1_CN_RUN_1/wigToBigWig";
$MM9_CHROM_SIZES="/scratch/iwase-lab/SAURABH/GENOMES/MM9/mm9.chrom.sizes";

$FOLDER="/scratch/iwase-lab/SAURABH/BRUSEQ_ANALYSIS/BRUSEQ_LSD1_CN_RUN_1/TOPHAT/TOPHAT_FINISHED_AND_MERGED_BAM_FILES_RUN_1";

open (COUNT_FILE,"<../READ_COUNTS/READ_SUMMARY.txt");
$n=0;
while ($line = <COUNT_FILE>)
{
$n++;
chomp $line;
@INFO=split("\t",$line);
$SAMPLE=$INFO[0];
$NORM_FACTOR=$INFO[10];

print color ("yellow"), "\n\n$n\t$SAMPLE\t$NORM_FACTOR\n", color ("reset");
$BAMFILE="$FOLDER/Merged_$SAMPLE.bam";
system ("ls -l $BAMFILE");

$BEDTOOLS_GENOME_COVERAGE_COMMAND="$BEDTOOLS_GENOME_COVERAGE -bg -g $MM9_CHROM_SIZES -scale $NORM_FACTOR -split -ibam -";

print STDERR "$n\t$SAMPLE\t$NORM_FACTOR\n$BEDTOOLS_GENOME_COVERAGE_COMMAND\n";

print scalar localtime, "Creating Positive Strand File\n";
system("samtools view -u -b -F 0x10 -F 0x100 $BAMFILE |$BEDTOOLS_GENOME_COVERAGE_COMMAND > $SAMPLE.POS_STRAND.bedgraph"); sleep 3;
system("$WigToBigWig $SAMPLE.POS_STRAND.bedgraph $MM9_CHROM_SIZES $SAMPLE.POS_STRAND.bw &"); sleep 1;

print scalar localtime, "Creating Negative Strand File\n";
system("samtools view -u -b -f 0x10 -F 0x100 $BAMFILE |$BEDTOOLS_GENOME_COVERAGE_COMMAND > $SAMPLE.NEG_STRAND.bedgraph"); sleep 3;
system("$WigToBigWig $SAMPLE.NEG_STRAND.bedgraph $MM9_CHROM_SIZES $SAMPLE.NEG_STRAND.bw &"); sleep 1;



print HEADER "track type=bigWig name=\"$SAMPLE.POS_STRAND\" description=\"$SAMPLE.POS_STRAND\" bigDataUrl=http://enhancer.ucsd.edu/DATA/download/saurabh/KITZMAN/$SAMPLE.POS_STRAND.bw visibility=full color=255,0,0 autoScale=off alwaysZero=off gridDefault=off maxHeightPixels=100 graphType=bar viewLimits=0.2:5 windowingFunction=mean smoothingWindow=2 altColor=0,0,255\n";

print HEADER "track type=bigWig name=\"$SAMPLE.NEG_STRAND\" description=\"$SAMPLE.NEG_STRAND\" bigDataUrl=http://enhancer.ucsd.edu/DATA/download/saurabh/KITZMAN/$SAMPLE.NEG_STRAND.bw visibility=full color=255,0,0 autoScale=off alwaysZero=off gridDefault=off maxHeightPixels=100 graphType=bar viewLimits=-5:-0.2 windowingFunction=mean smoothingWindow=2 altColor=255,0,0\n";
}
close COUNT_FILE;
close STDERR;
close HEADER;
print color("green"), "Done !!!\nDone !!!\nDone !!!\nDone !!!\nDone !!!\nDone !!!\n", color ("reset");
