#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor;
use List::Util qw[min max];

$BEDTOOLS="/home/saurabha/UTILITIES/BEDTOOLS/BEDTOOLS_2/bin";
$sortBed="$BEDTOOLS/sortBed";
$intersectBed="$BEDTOOLS/intersectBed";
###############################################
$FEATURECOUNTS_FILE="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/NEURONAL_ENHANCERS/MALIK_ENHANCERS/ALL_CN_INTERGENIC_ENHANCERS";
open (ENHANCER_INFO_FROM_FEATURECOUNTS,"cat $FEATURECOUNTS_FILE|grep -v Program:featureCounts|grep -v CNWT_C2.bam|");
open (BEDFILE_1KB_ENHANCERS,">ALL_CN_INTERGENIC_ENHANCERS.bed");

while ($line = <ENHANCER_INFO_FROM_FEATURECOUNTS>)
{
	chomp $line;	
	@INFO=split ("\t",$line);
	$ENHANCER_ID = "$INFO[0]:::$INFO[1]:::$INFO[2]:::$INFO[3]"; 
	$LEFT  = $INFO[2]+500;
	$RIGHT = $INFO[3]-500;
	print BEDFILE_1KB_ENHANCERS "$INFO[1]\t$LEFT\t$RIGHT\t$ENHANCER_ID\n";
}
close BEDFILE_1KB_ENHANCERS;
###############################################
$FOLDER="/mnt/iwase/AGARWAL/External_mCN_Data_ROSENFELD/PEAK_CALLING";

@NOT_ANALYZED=qw(
LSD1_KClminus_CN_MGR_SRR1652082_4_bw1_mm9.nodup_q0.01_peaks
LSD1_KClminus_CN_MGR_SRR1652082_4_bw1_mm9.nodup_q0.02_peaks
Merged_19M_LSD1_mCN_mm9_q0.01_peaks
Merged_19M_LSD1_mCN_mm9_q0.02_peaks
Merged_Raw_LSD1_mCN_mm9_q0.01_peaks
Merged_Raw_LSD1_mCN_mm9_q0.02_peaks
LSD1_KClminus_CN_MGR_SRR1652082_4_bw1_mm9.nodup_q0.05_peaks
Merged_19M_LSD1_mCN_mm9_q0.05_peaks
);


@SAMPLES=qw(Merged_Raw_LSD1_mCN_mm9_q0.05_peaks);

@TYPES=qw(INCREASED DECREASED SAME NONE);
for $x (0 .. 3)
{ 
	system("cat ALL_CN_INTERGENIC_ENHANCERS.bed |grep $TYPES[$x] > $TYPES[$x].bed");
	$ENHANCER_FILE="$TYPES[$x].bed";
	($eCOUNT,$FILE)=split("\s",`wc -l $ENHANCER_FILE`);
	print color ("yellow"), "####### $x $ENHANCER_FILE TOTAL=  ",`wc -l $ENHANCER_FILE`;

for $y (0 .. 0)
{
	$PEAK_FILE=$SAMPLES[$y];
	print color ("green"), "$y\t$PEAK_FILE\t";
	$BOUND_FILE   =   "LSD1_BOUND_$TYPES[$x]"."_$PEAK_FILE";
	$UNBOUND_FILE = "LSD1_UNBOUND_$TYPES[$x]"."_$PEAK_FILE";
	$MERGED_FILE  = "ALL_$TYPES[$x]"."_$PEAK_FILE.bed";
	system("$intersectBed -wa -u -a  $TYPES[$x].bed -b $FOLDER/$PEAK_FILE.narrowPeak > $BOUND_FILE.bed");
	system("$intersectBed -wa -v -a  $TYPES[$x].bed -b $FOLDER/$PEAK_FILE.narrowPeak > $UNBOUND_FILE.bed");
	
	($bCOUNT,$FILE)=split(" ",`wc -l $BOUND_FILE.bed`);   $bP=int($bCOUNT*10000/$eCOUNT)/100;
	($uCOUNT,$FILE)=split(" ",`wc -l $UNBOUND_FILE.bed`); $uP=int($uCOUNT*10000/$eCOUNT)/100;
	print "BOUND=$bCOUNT\t$bP%\t UNBOUND=$uCOUNT\t$uP%\n";
##########################
	open (MERGED_BED,"|bedtools sort -i stdin > $MERGED_FILE"); 
	
	open (BOUND_BED,"$BOUND_FILE.bed");
	while ($line=<BOUND_BED>)
	{
		chomp $line;
		@INFO=split("\t",$line);
		print MERGED_BED "$INFO[0]\t$INFO[1]\t$INFO[2]\t$INFO[3]:::LSD1_BOUND\n";
	}
	close BOUND_BED;

	open (UNBOUND_BED,"$UNBOUND_FILE.bed");
	while ($line=<UNBOUND_BED>)
	{
		chomp $line;
		@INFO=split("\t",$line);
		print MERGED_BED "$INFO[0]\t$INFO[1]\t$INFO[2]\t$INFO[3]:::LSD1_UNBOUND\n";
	}
	close UNBOUND_BED;
	close MERGED_BED;
	system ("wc -l $BOUND_FILE.bed $UNBOUND_FILE.bed $MERGED_FILE"); 
}
}
################## CHECK ################## 
system("$intersectBed -wa -u -a  ALL_CN_INTERGENIC_ENHANCERS.bed -b $FOLDER/$PEAK_FILE.narrowPeak > BOUND_ALL_CN_INTERGENIC_ENHANCERS.bed");
system("$intersectBed -wa -v -a  ALL_CN_INTERGENIC_ENHANCERS.bed -b $FOLDER/$PEAK_FILE.narrowPeak > UNBOUND_ALL_CN_INTERGENIC_ENHANCERS.bed");

	open (MERGED_BED,"|bedtools sort -i stdin > ALL_CN_INTERGENIC_ENHANCERS_WITH_LSD1_BINDING_INFO.bed"); 
	
	open (BOUND_BED,"BOUND_ALL_CN_INTERGENIC_ENHANCERS.bed");
	while ($line=<BOUND_BED>)
	{
		chomp $line;
		@INFO=split("\t",$line);
		print MERGED_BED "$INFO[0]\t$INFO[1]\t$INFO[2]\t$INFO[3]:::LSD1_BOUND\n";
	}
	close BOUND_BED;

	open (UNBOUND_BED,"UNBOUND_ALL_CN_INTERGENIC_ENHANCERS.bed");
	while ($line=<UNBOUND_BED>)
	{
		chomp $line;
		@INFO=split("\t",$line);
		print MERGED_BED "$INFO[0]\t$INFO[1]\t$INFO[2]\t$INFO[3]:::LSD1_UNBOUND\n";
	}
	close UNBOUND_BED;
	close MERGED_BED;
	print "PEAK FILE=$PEAK_FILE\n";
	system ("cat ALL_*_$PEAK_FILE.bed |bedtools sort -i stdin > CHECK_ALL_CN_INTERGENIC_ENHANCERS_WITH_LSD1_BINDING_INFO.bed");
	print "Now Checking\n\n\n";
	system ("diff ALL_CN_INTERGENIC_ENHANCERS_WITH_LSD1_BINDING_INFO.bed CHECK_ALL_CN_INTERGENIC_ENHANCERS_WITH_LSD1_BINDING_INFO.bed");



