#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 

open  (CN_ENHANCER_BEDFILE,"/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/NEURONAL_ENHANCERS/NEW_OVERLAP/ALL_CN_INTERGENIC_ENHANCERS_WITH_LSD1_BINDING_INFO.bed");
while ($line=<CN_ENHANCER_BEDFILE>)
{
	chomp $line;
	@INFO=split("\t",$line);
	($ENHANCER_TYPE,$CHR,$L,$R,$LSD1_BINDING)=split(":::",$INFO[3]);
	$ENHANCER_ID=join(":::",$ENHANCER_TYPE,$CHR,$L,$R);
	if ($LSD1_BINDING eq 'LSD1_BOUND')   {$BINDING_BY_LSD1{$ENHANCER_ID}='YES';$COLOR{$ENHANCER_ID}="dodgerblue2\tdodgerblue2";  }
	if ($LSD1_BINDING ne 'LSD1_BOUND')   {$BINDING_BY_LSD1{$ENHANCER_ID}='NO' ;$COLOR{$ENHANCER_ID}="gray70\tgray70";}
}
close CN_ENHANCER_BEDFILE;
###############################################
@GROUPS=qw(DECR INCR NONE SAME);
$L{'INCR'}='AA';
$L{'DECR'}='BB';
$L{'SAME'}='CC';
$L{'NONE'}='DD';

for $g (0 .. 3) {
	$FILEHANDLE="SCATTER_$GROUPS[$g]";open ($FILEHANDLE, "|sort -k 4,4r >$FILEHANDLE.txt");
	$FILEHANDLE="ALL_$GROUPS[$g]";	  open ($FILEHANDLE, ">DATA_FOR_WILCOXON_$FILEHANDLE.txt");
	$FILEHANDLE="BOUND_$GROUPS[$g]";  open ($FILEHANDLE, ">DATA_FOR_WILCOXON_$FILEHANDLE.txt");
	$FILEHANDLE="UNBOUND_$GROUPS[$g]";open ($FILEHANDLE, ">DATA_FOR_WILCOXON_$FILEHANDLE.txt");
}

open (RAW_BRUSEQ, "cat /scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/NEURONAL_ENHANCERS/MALIK_ENHANCERS/ALL_CN_INTERGENIC_ENHANCERS|grep -v Program:featureCounts|grep -v LSD1_A2.bam|");
open (DATA_FOR_BOXPLOT,">DATA_FOR_BOXPLOT_CN_ENHANCERS.txt");
open (DATA_FOR_BOXPLOT_2,">DATA_FOR_BOXPLOT_CN_ENHANCERS_AVERAGE.txt");
open (DATA_FOR_LINEAR_BOXPLOT,">DATA_FOR_LINEAR_BOXPLOT.txt");

print DATA_FOR_BOXPLOT "VALUE\tFEATURE\n";
print DATA_FOR_BOXPLOT_2 "VALUE\tFEATURE\n";
print DATA_FOR_LINEAR_BOXPLOT "VALUE\tFEATURE\n";

while ($line = <RAW_BRUSEQ>)
{
$x++;
chomp $line;
($Geneid,$Chr,$Start,$End,$Strand,$Length,$LSD1_A2,$LSD1_B2,$CNWT_C2,$CNWT_U2,$LSD1_A3,$LSD1_B3,$CNWT_C3,$CNWT_U3)=split("\t",$line);
$ENHANCER_ID=join(":::",$Geneid,$Chr,$Start,$End);

$LSD1_A2=$LSD1_A2/3.7606779;
$LSD1_B2=$LSD1_B2/2.739595;
$CNWT_C2=$CNWT_C2/2.539281;
$CNWT_U2=$CNWT_U2/2.7384992;
$LSD1_A3=$LSD1_A3/2.8050292;
$LSD1_B3=$LSD1_B3/3.3665791;
$CNWT_C3=$CNWT_C3/3.0564626;
$CNWT_U3=$CNWT_U3/2.3642211;

$LA=($LSD1_A2+$LSD1_A3)/2;
$LB=($LSD1_B2+$LSD1_B3)/2;
$LC=($CNWT_C2+$CNWT_C3)/2;
$LU=($CNWT_U2+$CNWT_U3)/2;

$LSD1_A=log($LA+0.01)/log(10);
$LSD1_B=log($LB+0.01)/log(10);
$CNWT_C=log($LC+0.01)/log(10);
$CNWT_U=log($LU+0.01)/log(10);

$CONTROL=log(($LC+$LU)/2+0.01)/log(10);
$LSD1_KO=log(($LA+$LB)/2+0.01)/log(10);

$DIFFERENCE=$LSD1_KO-$CONTROL;

$SUM=$LSD1_A+$LSD1_B+$CNWT_C+$CNWT_U;

$P[0]=substr($Geneid,0,4);
$FILEHANDLE=$P[0];
if (($DIFFERENCE >  0.150514) && ($BINDING_BY_LSD1{$ENHANCER_ID} eq 'YES')) {$UP_AND_BOUND{$FILEHANDLE}  = $UP_AND_BOUND{$FILEHANDLE}+1;  $COLOR{$ENHANCER_ID}="dodgerblue2\tdodgerblue2";}
if (($DIFFERENCE < -0.150514) && ($BINDING_BY_LSD1{$ENHANCER_ID} eq 'YES')) {$DOWN_AND_BOUND{$FILEHANDLE}= $DOWN_AND_BOUND{$FILEHANDLE}+1;$COLOR{$ENHANCER_ID}="dodgerblue2\tdodgerblue2";}
$SCATTER_FILE="SCATTER_$P[0]"; print $SCATTER_FILE "$CONTROL\t$LSD1_KO\t$COLOR{$ENHANCER_ID}\n";

$LABEL[0]=$L{$P[0]}.$P[0];
#print DATA_FOR_BOXPLOT "$LSD1_A\t$P[0]C_LSD1_A\n$LSD1_B\t$P[0]D_LSD1_B\n$CNWT_C\t$P[0]B_CNWT_C\n$CNWT_U\t$P[0]A_CNWT_U\n\t$P[0]G_GAP\n";
#print DATA_FOR_BOXPLOT_2 "$CONTROL\t$P[0]E_Control_Ave\n$LSD1_KO\t$P[0]F_LSD1_KD_Ave\n\t$P[0]G_GAP\n";
#print DATA_FOR_LINEAR_BOXPLOT "$LA\t$P[0]C_LSD1_A\n$LB\t$P[0]D_LSD1_B\n$LC\t$P[0]B_CNWT_C\n$LU\t$P[0]A_CNWT_U\n\t$P[0]G_GAP\n";

	$FILEHANDLE="ALL_$P[0]";	  print $FILEHANDLE "$DIFFERENCE\n";
	if (($BINDING_BY_LSD1{$ENHANCER_ID} eq 'YES') && ($DIFFERENCE ne 0)) {$FILEHANDLE="BOUND_$P[0]";  print $FILEHANDLE "$DIFFERENCE\n";}
	if (($BINDING_BY_LSD1{$ENHANCER_ID} ne 'YES') && ($DIFFERENCE ne 0)) {$FILEHANDLE="UNBOUND_$P[0]";print $FILEHANDLE "$DIFFERENCE\n";}
}
system ("cat DATA_FOR_BOXPLOT_CN_ENHANCERS_AVERAGE.txt |grep -v DDNONEG_GAP > DATA_FOR_BOXPLOT_CN_ENHANCERS_2.txt");
close RAW_BRUSEQ;
close DATA_FOR_BOXPLOT;
close DATA_FOR_BOXPLOT_2;
close DATA_FOR_WILCOXON;
close DATA_FOR_LINEAR_BOXPLOT;


for $g (0 .. 3) 
{
	$FILEHANDLE=$GROUPS[$g];close $FILEHANDLE;
	print "$FILEHANDLE UP_AND_BOUND   = $UP_AND_BOUND{$FILEHANDLE}\n";
	print "$FILEHANDLE DOWN_AND_BOUND = $DOWN_AND_BOUND{$FILEHANDLE}\n";

	$FILEHANDLE="SCATTER_$GROUPS[$g]";close $FILEHANDLE;
	system ("Rscript SCATTER_PLOT.R $FILEHANDLE.txt $FILEHANDLE.png");
	
	$FILEHANDLE="ALL_$GROUPS[$g]";	  close $FILEHANDLE; print color ("yellow"); system ("Rscript P_VALUE_CALCULATION.R DATA_FOR_WILCOXON_$FILEHANDLE.txt"); 
	$FILEHANDLE="BOUND_$GROUPS[$g]";  close $FILEHANDLE; print color ("cyan");   #system ("Rscript P_VALUE_CALCULATION.R DATA_FOR_WILCOXON_$FILEHANDLE.txt"); 
	$FILEHANDLE="UNBOUND_$GROUPS[$g]";close $FILEHANDLE; print color ("reset");  #system ("Rscript P_VALUE_CALCULATION.R DATA_FOR_WILCOXON_$FILEHANDLE.txt"); 
	<STDIN>;
}




