#!/usr/bin/env Rscript
library(scales)
args <- commandArgs(trailingOnly=TRUE)
print(args)

GROSEQ <-as.matrix(read.table(args[1],header=FALSE,dec = "."))
WT <- as.numeric(GROSEQ[,1])
KO <- as.numeric(GROSEQ[,2])
C  <- GROSEQ[,3]
CEX <- as.numeric (GROSEQ[,4])
ALPHA <- as.numeric (GROSEQ[,5])
PCH <- as.numeric (GROSEQ[,6])
BG <- GROSEQ[,7]

png(file=args[2],width=1000,height=980)
plot(WT, KO, col=alpha(C, ALPHA), ylim=c(0.9,4.6), xlim=c(0.9,4.6), cex=CEX, pch=21, bg=BG, xaxs="i", asp=1, tck=-0.02,cex.axis=2, las=2,xlab="",ylab="" )
lines(x = c(-5,50), y = c(-5,50), lty=5, col="gray25")
lines(lowess(WT,KO), col=alpha("red",0.8), lty=2, lwd=3)

png(file=args[3],width=1500,height=1440)
plot(WT, KO, col=alpha(C, ALPHA), ylim=c(0.9,4.6), xlim=c(0.9,4.6), cex=CEX*1.5, pch=21, bg=BG, xaxs="i", asp=1, tck=-0.02,cex.axis=2, las=2,xlab="",ylab="" )
lines(x = c(-5,50), y = c(-5,50), lty=5, col="gray25")
lines(lowess(WT,KO), col=alpha("red",0.8), lty=2, lwd=3)

