#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 


@GROUPS=qw(DECR INCR NONE SAME);
$L{'INCR'}='AA';
$L{'DECR'}='BB';
$L{'SAME'}='CC';
$L{'NONE'}='DD';

for $g (0 .. 3) {$FILEHANDLE=$GROUPS[$g];open ($FILEHANDLE, ">DATA_FOR_WILCOXON_$GROUPS[$g].txt");}

open (RAW_BRUSEQ, "cat ../ALL_CN_INTERGENIC_ENHANCERS|grep -v Program:featureCounts|grep -v LSD1_A2.bam|");
open (DATA_FOR_BOXPLOT,">DATA_FOR_BOXPLOT_CN_ENHANCERS.txt");
open (DATA_FOR_BOXPLOT_2,">DATA_FOR_BOXPLOT_CN_ENHANCERS_AVERAGE.txt");
open (DATA_FOR_LINEAR_BOXPLOT,">DATA_FOR_LINEAR_BOXPLOT.txt");

print DATA_FOR_BOXPLOT "VALUE\tFEATURE\n";
print DATA_FOR_BOXPLOT_2 "VALUE\tFEATURE\n";
print DATA_FOR_LINEAR_BOXPLOT "VALUE\tFEATURE\n";

while ($line = <RAW_BRUSEQ>)
{
$x++;
chomp $line;
($Geneid,$Chr,$Start,$End,$Strand,$Length,$LSD1_A2,$LSD1_B2,$CNWT_C2,$CNWT_U2,$LSD1_A3,$LSD1_B3,$CNWT_C3,$CNWT_U3)=split("\t",$line);
$LSD1_A2=$LSD1_A2/3.7606779;
$LSD1_B2=$LSD1_B2/2.739595;
$CNWT_C2=$CNWT_C2/2.539281;
$CNWT_U2=$CNWT_U2/2.7384992;
$LSD1_A3=$LSD1_A3/2.8050292;
$LSD1_B3=$LSD1_B3/3.3665791;
$CNWT_C3=$CNWT_C3/3.0564626;
$CNWT_U3=$CNWT_U3/2.3642211;

$LA=($LSD1_A2+$LSD1_A3)/2;
$LB=($LSD1_B2+$LSD1_B3)/2;
$LC=($CNWT_C2+$CNWT_C3)/2;
$LU=($CNWT_U2+$CNWT_U3)/2;

$LSD1_A=log($LA+0.01)/log(10);
$LSD1_B=log($LB+0.01)/log(10);
$CNWT_C=log($LC+0.01)/log(10);
$CNWT_U=log($LU+0.01)/log(10);

$CONTROL=0.5*($CNWT_C+$CNWT_U);
$LSD1_KO=0.5*($LSD1_A+$LSD1_B);

$DIFFERENCE=$LSD1_KO-$CONTROL;

$SUM=$LSD1_A+$LSD1_B+$CNWT_C+$CNWT_U;

$P[0]=substr($Geneid,0,4);
$FILEHANDLE=$P[0];
$P[0]=$L{$P[0]}.$P[0];
print DATA_FOR_BOXPLOT "$LSD1_A\t$P[0]C_LSD1_A\n$LSD1_B\t$P[0]D_LSD1_B\n$CNWT_C\t$P[0]B_CNWT_C\n$CNWT_U\t$P[0]A_CNWT_U\n\t$P[0]G_GAP\n";
print DATA_FOR_BOXPLOT_2 "$CONTROL\t$P[0]E_Control_Ave\n$LSD1_KO\t$P[0]F_LSD1_KD_Ave\n\t$P[0]G_GAP\n";
print DATA_FOR_LINEAR_BOXPLOT "$LA\t$P[0]C_LSD1_A\n$LB\t$P[0]D_LSD1_B\n$LC\t$P[0]B_CNWT_C\n$LU\t$P[0]A_CNWT_U\n\t$P[0]G_GAP\n";

print $FILEHANDLE "$DIFFERENCE\n";
}
system ("cat DATA_FOR_BOXPLOT_CN_ENHANCERS_AVERAGE.txt |grep -v DDNONEG_GAP > DATA_FOR_BOXPLOT_CN_ENHANCERS_2.txt");
close RAW_BRUSEQ;
close DATA_FOR_BOXPLOT;
close DATA_FOR_BOXPLOT_2;
close DATA_FOR_WILCOXON;
close DATA_FOR_LINEAR_BOXPLOT;
system ("Rscript BOXPLOT.R");




