#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 
##############
$BRUSEQ_FOLDER="/scratch/iwase-lab/SAURABH/BRUSEQ_ANALYSIS/BRUSEQ_LSD1_CN_RUN_1/FEATURECOUNTS/DESEQ_ANALYSIS";

@COMPARISONS=qw(DESEQ_PAIR1_UNTREATED_v_CONTROL.txt
DESEQ_PAIR2_UNTREATED_v_shRNA_A.txt
DESEQ_PAIR3_UNTREATED_v_shRNA_B.txt
DESEQ_PAIR4_CONTROL_v_shRNA_A.txt
DESEQ_PAIR5_CONTROL_v_shRNA_B.txt);

for $x (0 .. 4)
{
$COMPARISON=$COMPARISONS[$x];

open (DESEQ_RESULTS,"cat $BRUSEQ_FOLDER/$COMPARISON|grep -v baseMeanB |");
$n=0;
while ($line = <DESEQ_RESULTS>)
{
$n++;
chomp $line;
($num,$id,$baseMean,$baseMeanA,$baseMeanB,$foldChange,$log2FoldChange,$pval,$padj)=split("\t",$line);
$ID[$x][$n]=$id;
if ($ID[$x][$n] ne $ID[0][$n]) {print "GeneIDs do not match\n";die;}

$LOG2CHANGE=log(($baseMeanB+0.1)/($baseMeanA+0.1))/log(2);

if ($x eq 0) {$LOG_CON_UNT{$id}=$LOG2CHANGE;$Q_CON_UNT{$id}=$padj;}
if ($x eq 1) {$LOG_shA_UNT{$id}=$LOG2CHANGE;$Q_shA_UNT{$id}=$padj;}
if ($x eq 2) {$LOG_shB_UNT{$id}=$LOG2CHANGE;$Q_shB_UNT{$id}=$padj;}
if ($x eq 3) {$LOG_shA_CON{$id}=$LOG2CHANGE;$Q_shA_CON{$id}=$padj;}
if ($x eq 4) {$LOG_shB_CON{$id}=$LOG2CHANGE;$Q_shB_CON{$id}=$padj;}

}
close DESEQ_RESULTS;
}
################
$ARG_FOLDER="/scratch/iwase-lab/SAURABH/LSD1_RNASEQ_ANALYSIS/SMCX_CN_RNASEQ/FEATURECOUNTS/DESEQ_ANALYSIS";

system ("paste $ARG_FOLDER/DESEQ_Merged_REP_1.txt   $ARG_FOLDER/DESEQ_Merged_REP_2.txt   > DESEQ_MERGED_PASTED.txt");
system ("paste $ARG_FOLDER/DESEQ_Separate_REP_1.txt $ARG_FOLDER/DESEQ_Separate_REP_2.txt > DESEQ_WTONLY_PASTED.txt");
system ("wc -l $ARG_FOLDER/DESEQ_Merged_REP_1.txt");
system ("wc -l DESEQ_MERGED_PASTED.txt DESEQ_WTONLY_PASTED.txt");

@CN_FILES=qw(DESEQ_MERGED_PASTED.txt DESEQ_WTONLY_PASTED.txt);

for $x (0 .. 1)
{
$CN_FILE=$CN_FILES[$x];
$UPREGULATED_ARG[$x]=0;
$DOWNREGULATED_ARG[$x]=0;
$SIG_shA_ARG=$SIG_shB_ARG=0;

open (DATA_FOR_BOXPLOT,">DATA_FOR_BOXPLOT_$CN_FILE");
open (UPREGULATED_CDG,">LIST_CDGs_$CN_FILE");

print DATA_FOR_BOXPLOT "value\tfeature\n";

open(DESEQ_RESULTS,"cat $CN_FILES[$x]|grep -v baseMeanB|");

NEXT_GENE:while ($line = <DESEQ_RESULTS>)
{
chomp $line;
($num,$id1,$baseMean1,$baseMeanA1,$baseMeanB1,$foldChange1,$log2FoldChange1,$P1,$Q1,$num,$id2,$baseMean2,$baseMeanA2,$baseMeanB2,$foldChange2,$log2FoldChange2,$P2,$Q2)=split("\t",$line);
$id=$id1;
if ($id1 ne $id2) {print "GeneIDs do not match\n";die;}

$LOG2CHANGE_1=log(($baseMeanB1+0.1)/($baseMeanA1+0.1))/log(2);
$LOG2CHANGE_2=log(($baseMeanB2+0.1)/($baseMeanA2+0.1))/log(2);
$AVERAGE_LOG=($LOG2CHANGE_1+$LOG2CHANGE_2)/2;
if (($P1 eq 'NA') || ($P2 eq 'NA')) {next NEXT_GENE;}

if (($P1 ne 'NA') && ($P2 ne 'NA') && ($P1 < 0.05) && ($P2 < 0.05))
{
$COMBINED_P=$P1*$P2*(1 - log(($P1*$P2)+0.0000000001));
if (($LOG2CHANGE_1 > 0) && ($LOG2CHANGE_2 > 0) && ($COMBINED_P < 0.025)) {
	$UPREGULATED_ARG[$x]++;print color ("cyan"), "$id\t";print DATA_FOR_BOXPLOT "$AVERAGE_LOG\tA_AVE_LOG_UP\n";
	print DATA_FOR_BOXPLOT "$LOG_CON_UNT{$id}\tA_CON_UNT\n$LOG_shA_UNT{$id}\tC_shA_UNT\n$LOG_shB_UNT{$id}\tE_shB_UNT\n$LOG_shA_CON{$id}\tG_shA_CON\n$LOG_shB_CON{$id}\tI_shB_CON\n";
	if (($LOG_shA_CON{$id} > 0) && ($Q_shA_CON{$id} < 0.1)) {$SIG_shA_ARG++;print UPREGULATED_CDG "A\t$id\n";}
	if (($LOG_shB_CON{$id} > 0) && ($Q_shB_CON{$id} < 0.1)) {$SIG_shB_ARG++;print UPREGULATED_CDG "B\t$id\n";}}
}
}
print "$CN_FILE Upregulated with shA =$SIG_shA_ARG\n";
print "$CN_FILE Upregulated with shB =$SIG_shB_ARG\n";
close UPREGULATED_CDG;
close DATA_FOR_BOXPLOT;
close DESEQ_RESULTS;
system ("sort -k1 LIST_CDGs_$CN_FILE > Sorted_LIST_CDGs_$CN_FILE");
print "\n$x $CN_FILE UPREGULATED_ARGs=  $UPREGULATED_ARG[$x]";
print "\n$x $CN_FILE DOWNREGULATED_ARGs=$DOWNREGULATED_ARG[$x]\n\n\n";

@TYPES=qw(A_CON_UNT C_shA_UNT E_shB_UNT G_shA_CON I_shB_CON);
for $t (0 .. $#TYPES)
{
print color("red"),"FOR_WILCOXON_$TYPES[$t]_$CN_FILE\n",color("cyan");
system("cat DATA_FOR_BOXPLOT_$CN_FILE | grep $TYPES[$t] |cut -f1 |grep -v value > FOR_WILCOXON_$TYPES[$t]_$CN_FILE");
system ("wc -l FOR_WILCOXON_$TYPES[$t]_$CN_FILE");
system("Rscript P_VALUE_CALCULATION.R FOR_WILCOXON_$TYPES[$t]_$CN_FILE; sleep 3");
}
	}
print color ("reset");
system ("Rscript BOXPLOT_ARG_MISREGULATION_2.R");








