#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 

$FEATURE_COUNTS="/home/saurabha/UTILITIES/SUBREAD/subread-1.5.0-p1-source/bin/featureCounts";
$ENTREZ_ANNOTATION="/home/saurabha/UTILITIES/SUBREAD/subread-1.5.0-p1-source/annotation/mm9_RefSeq_exon.txt";
$UCSC_ANNOTATION="/scratch/iwase-lab/SAURABH/ANNOTATIONS/MM9/archive-2014-05-23-16-05-24/Genes/genes_mm9.gtf";

$ANNOTATION_FILE_USED=$UCSC_ANNOTATION;

system ("rm ANNOTATION_FILE_USED.gtf; ls -l; sleep 1; ls -l $FEATURE_COUNTS; sleep 1; ls -l $GENE_ANNOTATION; wc -l $ENTREZ_ANNOTATION;");
system ("cat $ANNOTATION_FILE_USED |grep -v Rn45s|grep -v chrM > ANNOTATION_FILE_USED.gtf");
print "\n\n\n\n\n";

$FOLDER="/scratch/iwase-lab/SAURABH/External_RNASEQ_DATA/Simeone_Epiblast/TOPHAT_RUN/TOPHAT_FINISHED";

@FILES=qw(
WT_mES_Simeone_rep1_ERR1001692_1_MM9_Tophat2_bw2.bam:::mES1_r1
WT_mES_Simeone_rep2_ERR1001693_1_MM9_Tophat2_bw2.bam:::mES2_r1
WT_mEpiS_Simeone_rep1_ERR1001690_1_MM9_Tophat2_bw2.bam:::mEpiS1_r1
WT_mEpiS_Simeone_rep2_ERR1001691_1_MM9_Tophat2_bw2.bam:::mEpiS2_r1

WT_mES_Simeone_rep1_ERR1001692_2_MM9_Tophat2_bw2.bam:::mES1_r2
WT_mES_Simeone_rep2_ERR1001693_2_MM9_Tophat2_bw2.bam:::mES2_r2
WT_mEpiS_Simeone_rep1_ERR1001690_2_MM9_Tophat2_bw2.bam:::mEpiS1_r2
WT_mEpiS_Simeone_rep2_ERR1001691_2_MM9_Tophat2_bw2.bam:::mEpiS2_r2
);

for $x (0 .. $#FILES)
{
($BAMFILE,$MARK)=split(":::",$FILES[$x]);
system ("ln -s $FOLDER/$BAMFILE ./$MARK.bam");
print color ("cyan"),`ls -lh $FOLDER/$BAMFILE`,color ("yellow"),`ls -lh $MARK.bam`,"\n\n";
sleep 3;
$FILELIST=$FILELIST." $MARK.bam";
}
print color ("magenta"),"\n\n\n$FILELIST\n\n\n",color("reset");


$OPTIONS="-T 16 -a ANNOTATION_FILE_USED.gtf -t exon -g gene_id ";
$FEATURECOUNTS_COMMAND="$FEATURE_COUNTS $OPTIONS $FILELIST -o Simeone_WT_mES_EpiS_r1_r2";

system ("$FEATURECOUNTS_COMMAND");
sleep 3;
system("cat Simeone_WT_mES_EpiS_r1_r2|grep -v Program:featureCounts |cut -f 1,7-10 > Selected_Simeone_WT_mES_EpiS_r1");
system("cat Simeone_WT_mES_EpiS_r1_r2|grep -v Program:featureCounts |cut -f 1,11-14 > Selected_Simeone_WT_mES_EpiS_r2");

system ("rm -rf DESEQ_ANALYSIS; sleep 1; mkdir DESEQ_ANALYSIS");



