#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 

##############
$DESEQ_FOLDER="/scratch/iwase-lab/SAURABH/GROSEQ_ANALYSIS_NEW/SMCX_GROSEQ_eRNA_Change/DESEQ";
open (LSD1_DESEQ_RESULTS,"cat $DESEQ_FOLDER/DESEQ_RESULTS_LSD1_mES_GROSEQ_ALL_DHS.txt|grep -v log2FoldChange|");
while ($line = <LSD1_DESEQ_RESULTS>)
{
chomp $line;
@DATA=split("\t",$line);
$ID=$DATA[1];
$WT=$DATA[3];
$KO=$DATA[4];
$LSD1_LOG_CHANGE{$ID}=log(($KO+0.01)/($WT+0.01))/log(2);
$LSD1_Q{$ID}=$DATA[8];
}
close LSD1_DESEQ_RESULTS;
##############
open (SMCX_DESEQ_RESULTS,"cat $DESEQ_FOLDER/DESEQ_RESULTS_SMCX_mES_GROSEQ_ALL_DHS.txt |grep -v log2FoldChange|");
while ($line = <SMCX_DESEQ_RESULTS>)
{
chomp $line;
@DATA=split("\t",$line);
$ID=$DATA[1];
$WT=$DATA[3];
$KO=$DATA[4];
$SMCX_LOG_CHANGE{$ID}=log(($KO+0.01)/($WT+0.01))/log(2);
$SMCX_Q{$ID}=$DATA[7];
}
close SMCX_DESEQ_RESULTS;
##############
$QCUT="0.5";
$ENHANCER_LIST="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/Enhancer_Predcition/All_Mappable_Predicted_Enhancers.bed";
$LSD1_PEAKS="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/MACS2_PEAKS/LSD1_Peaks/LSD1_mES_ChipSeq_2_Young_SRR122470_19_bw1_mm9_Input_Merged_All_q0.05_peaks.narrowPeak";
$SMCX_PEAKS="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/MACS2_PEAKS/SMCX_Peaks/Merged_KDM5c_SMCX_WT_mES_rep12_bw1_mm9_Input_Merged_All_q_0.05_peaks.narrowPeak";

system ("wc -l $ENHANCER_LIST");

system ("cat $ENHANCER_LIST |grep -v browser|grep -v description > ALL_ENHANCERS.bed");
system ("bedtools intersect -wa -u -a ALL_ENHANCERS.bed -b $LSD1_PEAKS  > LSD1_BOUND_ENHANCERS.bed");
system ("bedtools intersect -wa -v -a ALL_ENHANCERS.bed -b $LSD1_PEAKS  > LSD1_UNBOUND_ENHANCERS.bed");
system ("bedtools intersect -wa -u -a ALL_ENHANCERS.bed -b $SMCX_PEAKS  > SMCX_BOUND_ENHANCERS.bed");
system ("bedtools intersect -wa -v -a ALL_ENHANCERS.bed -b $SMCX_PEAKS  > SMCX_UNBOUND_ENHANCERS.bed");
system ("bedtools intersect -wa -u -a ALL_ENHANCERS.bed -b $LSD1_PEAKS |bedtools intersect -wa -u -a stdin -b $SMCX_PEAKS > BOUND_BY_BOTH_ENHANCERS.bed");

system ("wc -l *_ENHANCERS.bed; sleep 3");

@QUERY_FILES=qw(ALL_ENHANCERS BOUND_BY_BOTH_ENHANCERS LSD1_BOUND_ENHANCERS LSD1_UNBOUND_ENHANCERS SMCX_BOUND_ENHANCERS SMCX_UNBOUND_ENHANCERS);

for $q (0 .. 1)
{
$QUERY=$QUERY_FILES[$q];

open (LIST_OF_ENHANCERS,"$QUERY.bed");
open (DESEQ_ENHANCERS,">DESEQ_RESULTS_$QUERY.txt");
open (LSD1_PLOT,">LSD1_PLOT_VALUES_$QUERY.plot");
open (SMCX_PLOT,">SMCX_PLOT_VALUES_$QUERY.plot");

print DESEQ_ENHANCERS "chr\tleft\tright\tid\tscore\tstrand\tLSD1_LOG2\tLSD1_Q\tSMCX_LOG2\tSMCX_Q\n";

$LSD1_SIG_UP=0;$LSD1_SIG_DOWN=0;	$SMCX_SIG_UP=0;$SMCX_SIG_DOWN=0;

NEXT_Enhancer:while ($line = <LIST_OF_ENHANCERS>)
{
chomp $line;
$LSD1_SIG="INSIG"; $SMCX_SIG="INSIG";

@DATA=split("\t",$line);
($ID,$TYPE,$GROSEQ,$K27,$K9)=split ("!!!",$DATA[3]);
print DESEQ_ENHANCERS "$line\t$LSD1_LOG_CHANGE{$ID}\t$LSD1_Q{$ID}\t$SMCX_LOG_CHANGE{$ID}\t$SMCX_Q{$ID}\n";

if (($LSD1_Q{$ID} eq 'NA') || ($LSD1_Q{$ID} eq 0)) {$LOGQ_LSD1=0.01;}
if (($LSD1_Q{$ID} ne 'NA') && ($LSD1_Q{$ID} ne 0)) {$LOGQ_LSD1=-1*log($LSD1_Q{$ID})/log(10);}
if ($LOGQ_LSD1 > 4.99) {$LOGQ_LSD1=4.99};
if ($LSD1_LOG_CHANGE{$ID} > 3.99) {$LSD1_LOG_CHANGE{$ID}=3.99;}
if ($LSD1_LOG_CHANGE{$ID} < -3.99) {$LSD1_LOG_CHANGE{$ID}=-3.99;}

if (($SMCX_Q{$ID} eq 'NA') || ($SMCX_Q{$ID} eq 0)) {$LOGQ_SMCX=0;}
if (($SMCX_Q{$ID} ne 'NA') && ($SMCX_Q{$ID} ne 0)) {$LOGQ_SMCX=-1*log($SMCX_Q{$ID})/log(10);}
if ($LOGQ_SMCX > 4.99) {$LOGQ_SMCX=4.99;}
if ($SMCX_LOG_CHANGE{$ID} > 3.99) {$SMCX_LOG_CHANGE{$ID}=3.99;}
if ($SMCX_LOG_CHANGE{$ID} < -3.99) {$SMCX_LOG_CHANGE{$ID}=-3.99;}

if (($LSD1_Q{$ID} ne 'NA') && ($LSD1_Q{$ID} < 0.05) && ($LSD1_LOG_CHANGE{$ID} < 0)) {$LSD1_SIG="DOWN";$LSD1_SIG_DOWN++; print LSD1_PLOT "$LSD1_LOG_CHANGE{$ID}\t\t$LOGQ_LSD1\n";}
if (($LSD1_Q{$ID} ne 'NA') && ($LSD1_Q{$ID} < 0.05) && ($LSD1_LOG_CHANGE{$ID} > 0)) {$LSD1_SIG="UP";  $LSD1_SIG_UP++;   print LSD1_PLOT "$LSD1_LOG_CHANGE{$ID}\t\t\t$LOGQ_LSD1\n";}

if (($SMCX_Q{$ID} ne 'NA') && ($SMCX_Q{$ID} < 0.05) && ($SMCX_LOG_CHANGE{$ID} < 0)) {$SMCX_SIG="DOWN";$SMCX_SIG_DOWN++; print SMCX_PLOT "$SMCX_LOG_CHANGE{$ID}\t\t$LOGQ_SMCX\n";}
if (($SMCX_Q{$ID} ne 'NA') && ($SMCX_Q{$ID} < 0.05) && ($SMCX_LOG_CHANGE{$ID} > 0)) {$SMCX_SIG="UP";  $SMCX_SIG_UP++;   print SMCX_PLOT "$SMCX_LOG_CHANGE{$ID}\t\t\t$LOGQ_SMCX\n";}

if ($LSD1_SIG eq "INSIG") {print LSD1_PLOT "$LSD1_LOG_CHANGE{$ID}\t$LOGQ_LSD1\n";}
if ($SMCX_SIG eq "INSIG") {print SMCX_PLOT "$SMCX_LOG_CHANGE{$ID}\t$LOGQ_SMCX\n";}
}
close DESEQ_ENHANCERS;
close LIST_OF_ENHANCERS;
close LSD1_PLOT; close SMCX_PLOT;
system ("wc -l $QUERY.bed DESEQ_RESULTS_$QUERY.txt");
#system ("Rscript VOLCANO_PLOT.R LSD1_PLOT_VALUES_$QUERY.plot LSD1_PLOT_VALUES_$QUERY.png");
#system ("Rscript VOLCANO_PLOT.R SMCX_PLOT_VALUES_$QUERY.plot SMCX_PLOT_VALUES_$QUERY.png");

print "$q\t$QUERY\nLSD1_UP=$LSD1_SIG_UP\nLSD1_DOWN=$LSD1_SIG_DOWN\nSMCX_UP=$SMCX_SIG_UP\nSMCX_DOWN=$SMCX_SIG_DOWN\n\n\n";
sleep 1;
}
