#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 

$ISOLATED_DHS_BED="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/DHS_SITES_INTERGENIC/ALL_mES_DHS_Isolated_1250bp.bed";
system("wc -l $ISOLATED_DHS_BED; ls -lh $ISOLATED_DHS_BED");
system ("cp -pvf $ISOLATED_DHS_BED ./");

open (ALL_ISOLATED_DHS_BED,"ALL_mES_DHS_Isolated_1250bp.bed");
open (SAF_FILE_500,">ALL_mES_DHS_Isolated_500bp.SAF");

print SAF_FILE_500 "GeneID\tChr\tStart\tEnd\tStrand\n";
while ($line = <ALL_ISOLATED_DHS_BED>) 
{
	chomp $line;
	($CHR,$LEFT,$RIGHT,$NAME,$SCORE,$STRAND)=split("\t",$line);
	@NAME_VALUES=split(":::",$NAME);
	$DHS_ID=$NAME_VALUES[0];
	$SUMMIT=$NAME_VALUES[2];

	$LEFT_500   =$SUMMIT-500;
	$RIGHT_500  =$SUMMIT+500;

	print SAF_FILE_500  "$NAME\t$CHR\t$LEFT_500\t$RIGHT_500\t.\n";
}

close SAF_FILE_500;
close SAF_FILE_1000;
system ("head *.SAF");


######### CREATE SYMLINKS ###########
$LSD1_FOLDER="/scratch/iwase-lab/SAURABH/GROSEQ_ANALYSIS_NEW/MAPPING/BBDUK/MERGED_BAMS_B1_B2";
$SMCX_FOLDER="/scratch/iwase-lab/SAURABH/GROSEQ_ANALYSIS_NEW/MAPPING/BBDUK";

@SAMPLE_INFO=qw(
LSD1_FOLDER::::LSD1_WT_1_GROSEQ::::Merged_LSD1_WT_mES_17_rep1_GROSEQ_B1B2_5_bowtie1_mm9.bam
LSD1_FOLDER::::LSD1_WT_2_GROSEQ::::Merged_LSD1_WT_mES_17_rep2_GROSEQ_B1B2_7_bowtie1_mm9.bam
LSD1_FOLDER::::LSD1_KO_1_GROSEQ::::Merged_LSD1_KO_mES_03_rep1_GROSEQ_B1B2_6_bowtie1_mm9.bam
LSD1_FOLDER::::LSD1_KO_2_GROSEQ::::Merged_LSD1_KO_mES_03_rep2_GROSEQ_B1B2_8_bowtie1_mm9.bam
SMCX_FOLDER::::SMCX_WT_1_GROSEQ::::Sorted_SMCX_WT_mES_F9_GROSEQ_A2_7_bowtie1_mm9.bam
SMCX_FOLDER::::SMCX_WT_2_GROSEQ::::Sorted_SMCX_WT_mES_F8_GROSEQ_A2_5_bowtie1_mm9.bam
SMCX_FOLDER::::SMCX_KO_1_GROSEQ::::Sorted_SMCX_KO_mES_C7_GROSEQ_A2_8_bowtie1_mm9.bam
SMCX_FOLDER::::SMCX_KO_2_GROSEQ::::Sorted_SMCX_KO_mES_C5_GROSEQ_A2_6_bowtie1_mm9.bam);

for $x(0 .. $#SAMPLE_INFO)
{
($FOLDER,$MARK,$FILE)=split("::::",$SAMPLE_INFO[$x]);
$BAMFILE="$$FOLDER/$FILE";
system ("ls -lh $BAMFILE"); sleep 1;
system ("ln -s $BAMFILE $MARK.bam");
$FILELIST=$FILELIST." $MARK.bam";
}
print color ("cyan"),"$FILELIST\n",color ("reset");

######################################
$FEATURECOUNTS="/home/saurabha/UTILITIES/SUBREAD/subread-1.5.0-p1-source/bin/featureCounts";

$OPTIONS="-T 15 -a ALL_mES_DHS_Isolated_500bp.SAF -F SAF -O -g GeneID ";

$COMMAND="$FEATURECOUNTS $OPTIONS $FILELIST -o ALL_DHS_GROSEQ_Estimation_WT_KO";
print "$COMMAND\n";
system ("$COMMAND");
sleep 3;
system("cat ALL_DHS_GROSEQ_Estimation_WT_KO |grep -v Program:featureCounts |cut -f 1,7-10 >  ALL_DHS_GROSEQ_Estimation_LSD1_WT_KO_FOR_DESEQ");
system("cat ALL_DHS_GROSEQ_Estimation_WT_KO |grep -v Program:featureCounts |cut -f 1,11-14 > ALL_DHS_GROSEQ_Estimation_SMCX_WT_KO_FOR_DESEQ");

print "Done !!!\nDone !!!\nDone !!!\nDone !!!\nDone !!!\n";












