#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 
##############
$ENHANCER_LIST="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/Enhancer_Predcition/All_Mappable_Predicted_Enhancers.bed";
$LSD1_PEAKS="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/MACS2_PEAKS/LSD1_Peaks/LSD1_mES_ChipSeq_2_Young_SRR122470_19_bw1_mm9_Input_Merged_All_q0.05_peaks.narrowPeak";
system ("wc -l $ENHANCER_LIST");

system ("cat $ENHANCER_LIST |grep -v browser|grep -v description > ALL.bed");
system ("bedtools intersect -wa -u -a ALL.bed -b $LSD1_PEAKS  > BOUND.bed");
system ("bedtools intersect -wa -v -a ALL.bed -b $LSD1_PEAKS  > UNBOUND.bed");
system ("wc -l *.bed; sleep 3");

open (DATA_FOR_BOXPLOT,">DATA_FOR_BOXPLOT.txt");
print DATA_FOR_BOXPLOT "VALUE\tFEATURE\n";

##############
$DESQ_DIR="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/NUCLEAR_TOTAL_EXPRESSION_CHANGE/DESEQ";
@COMPARISONS=qw(
ULSD1_GRO::::DESEQ_RESULTS_LSD1_ALL_DHS_GROSEQ_Estimation_WT_KO.txt::::58.95176367
VLSD1_NUC::::DESEQ_RESULTS_LSD1_ALL_DHS_NUCLEAR_Estimation_WT_KO.txt::::43.94861508
WLSD1_TOT::::DESEQ_RESULTS_LSD1_ALL_DHS_TOTAL_Estimation_WT_KO.txt::::27.06187265
XSMCX_GRO::::DESEQ_RESULTS_SMCX_ALL_DHS_GROSEQ_Estimation_WT_KO.txt::::24.66929367
YSMCX_NUC::::DESEQ_RESULTS_SMCX_ALL_DHS_NUCLEAR_Estimation_WT_KO.txt::::47.67894684);

				

for $x (0 .. 4)
{
($COMPARISON,$DESEQ_FILE,$NORMF)=split("::::",$COMPARISONS[$x]);
undef %WT; undef %KO; undef %LOG2CHANGE;

open (DESEQ_RESULTS,"$DESQ_DIR/$DESEQ_FILE");
while ($line = <DESEQ_RESULTS>)
{
chomp $line;
@DATA=split("\t",$line);
$ID=$DATA[1];
$WT{$ID}=log($DATA[3]/$NORMF +0.001)/log(10);
$KO{$ID}=log($DATA[4]/$NORMF +0.001)/log(10);
$LOG2CHANGE{$ID}=($KO{$ID}-$WT{$ID})*log(10)/log(2);
}
close DESEQ_RESULTS;
################
@QUERY_FILES=qw(ALL BOUND UNBOUND);
@COLOURS=qw(magenta cyan yellow magenta cyan);

$QUERY=$QUERY_FILES[0];
$PREFIX[0]=$COMPARISON;
$WILCOXON_FILE="$PREFIX[0]";
open (FOR_WILCOXON,">$WILCOXON_FILE.wil");

open (LIST_OF_ENHANCERS,"$QUERY.bed");
NEXT_Enhancer:while ($line = <LIST_OF_ENHANCERS>)
{
chomp $line;
@DATA=split("\t",$line);
($ID,$TYPE,$GROSEQ,$K27,$K9)=split ("!!!",$DATA[3]);

print DATA_FOR_BOXPLOT "$WT{$ID}\t$PREFIX[0]_AWT\n$KO{$ID}\t$PREFIX[0]_BKO\n$LOG2CHANGE{$ID}\t$PREFIX[0]_Change\n";
print FOR_WILCOXON "$LOG2CHANGE{$ID}\n";
}
close FOR_WILCOXON; 
print color ("$COLOURS[$x]"); system("Rscript P_VALUE_CALCULATION.R $WILCOXON_FILE.wil");print color("reset"); 
close LIST_OF_ENHANCERS;
}
print DATA_FOR_BOXPLOT "\tULSD1_GRO_ZGAP\n\tVLSD1_NUC_ZGAP\n\tWLSD1_TOT_ZGAP\n\tXSMCX_GRO_ZGAP\n";
close DATA_FOR_BOXPLOT;

system ("wc -l DATA_FOR_BOXPLOT.txt");
system ("head DATA_FOR_BOXPLOT.txt");
system ("Rscript boxplot.R DATA_FOR_BOXPLOT.txt Change_NUCLEAR_TOTAL_AT_ENHANCERS_ALL_ENHANCERS.pdf");



