#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 
##############
$ENHANCER_LIST="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/Enhancer_Predcition/All_Mappable_Predicted_Enhancers.bed";
$LSD1_PEAKS="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/MACS2_PEAKS/LSD1_Peaks/LSD1_mES_ChipSeq_2_Young_SRR122470_19_bw1_mm9_Input_Merged_All_q0.05_peaks.narrowPeak";
system ("wc -l $ENHANCER_LIST");

system ("cat $ENHANCER_LIST |grep -v browser|grep -v description > ALL.bed");
system ("bedtools intersect -wa -u -a ALL.bed -b $LSD1_PEAKS  > BOUND.bed");
system ("bedtools intersect -wa -v -a ALL.bed -b $LSD1_PEAKS  > UNBOUND.bed");
system ("wc -l *.bed; sleep 3");

open (DATA_FOR_BOXPLOT,">DATA_FOR_BOXPLOT.txt");
print DATA_FOR_BOXPLOT "VALUE\tFEATURE\n";

##############
$DESQ_DIR="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/NUCLEAR_TOTAL_EXPRESSION_CHANGE/DESEQ";
@COMPARISONS=qw(
ULSD1_GRO::::DESEQ_RESULTS_LSD1_ALL_DHS_GROSEQ_Estimation_WT_KO.txt::::58.95176367
VLSD1_NUC::::DESEQ_RESULTS_LSD1_ALL_DHS_NUCLEAR_Estimation_WT_KO.txt::::43.94861508
WLSD1_TOT::::DESEQ_RESULTS_LSD1_ALL_DHS_TOTAL_Estimation_WT_KO.txt::::27.06187265
XSMCX_GRO::::DESEQ_RESULTS_SMCX_ALL_DHS_GROSEQ_Estimation_WT_KO.txt::::24.66929367
YSMCX_NUC::::DESEQ_RESULTS_SMCX_ALL_DHS_NUCLEAR_Estimation_WT_KO.txt::::47.67894684);

				

for $x (0 .. 4)
{
($COMPARISON,$DESEQ_FILE,$NORMF)=split("::::",$COMPARISONS[$x]);
undef %WT; undef %KO; undef %LOG2CHANGE; undef %PVAL;

open (DESEQ_RESULTS,"$DESQ_DIR/$DESEQ_FILE");
while ($line = <DESEQ_RESULTS>)
{
chomp $line;
@DATA=split("\t",$line);
$ID=$DATA[1];
$WT{$ID}=log($DATA[3]/$NORMF +0.001)/log(10);
$KO{$ID}=log($DATA[4]/$NORMF +0.001)/log(10);
$LOG2CHANGE{$ID}=($KO{$ID}-$WT{$ID})*log(10)/log(2);
$PVAL{$ID}=$DATA[7];
if ($PVAL{$ID} eq 'NA'){$PVAL{$ID}=1;};
}
close DESEQ_RESULTS;
###########################
$NUP=0;$NDOWN=0;
open (LIST_OF_ENHANCERS,"ALL.bed");
open (DATA_FOR_SCATTER, "|sort -k 4 > DATA_FOR_SCATTER_$COMPARISON.txt");

NEXT_Enhancer:while ($line = <LIST_OF_ENHANCERS>)
{
chomp $line;
@DATA=split("\t",$line);
($ID,$TYPE,$GROSEQ,$K27,$K9)=split ("!!!",$DATA[3]);
$COLOR="gray25"; $CEX=1;
if (($PVAL{$ID} < 0.05) && ($WT{$ID} < $KO{$ID})) {$COLOR="blue";$CEX=1.4;$NUP++;}
if (($PVAL{$ID} < 0.05) && ($WT{$ID} > $KO{$ID})) {$COLOR="orange";$CEX=1.4;$NDOWN++;}

print DATA_FOR_SCATTER "$WT{$ID}\t$KO{$ID}\t$COLOR\t$CEX\n";
}
close LIST_OF_ENHANCERS;
close DATA_FOR_SCATTER;
system ("Rscript SCATTER_PLOT.R DATA_FOR_SCATTER_$COMPARISON.txt SCATTER_$COMPARISON.png");
print "$COMPARISON\tUP=$NUP\tDOWN=$NDOWN\n";
}






