#!/usr/bin/env Rscript
library(scales)
args <- commandArgs(trailingOnly=TRUE)
print(args)
LIMITS <- as.numeric(args[4])
LIMITS

GROSEQ <-as.matrix(read.table(args[1],header=FALSE,dec = "."))
WT <- as.numeric(GROSEQ[,1])
KO <- as.numeric(GROSEQ[,2])
C  <- GROSEQ[,3]
CEX <- as.numeric (GROSEQ[,4])
ALPHA <- as.numeric (GROSEQ[,5])

png(file=args[2],width=1000,height=980)
plot(WT, KO, col=alpha(C, ALPHA), ylim=c(-2,4), xlim=c(-2,4), cex=CEX, pch=16, xaxs="i", asp=1, cex.axis=2, las=2,xlab="",ylab="" )
lines(x = c(-5,50), y = c(-5,50), lty=5, col="black")
#lines(lowess(WT,KO), col="gray10", lwd=3)
par(new=TRUE)

SIGUP <-as.matrix(read.table(args[3],header=FALSE,dec = "."))
WTUP <- as.numeric(SIGUP[,1])
KOUP <- as.numeric(SIGUP[,2])
COL2  <- SIGUP[,3]
CEX2 <- as.numeric (SIGUP[,4])
ALPHA2 <- as.numeric (SIGUP[,5])
plot(WTUP, KOUP, col=alpha(COL2, ALPHA2), ylim=c(-2,4), xlim=c(-2,4), cex=CEX2, pch=16, xaxs="i", asp=1, cex.axis=2, las=2,xlab="",ylab="" )
lines(lowess(WT,KO), col="black", lwd=3)
lines(lowess(WTUP,KOUP), col="white", lwd=3.9)
lines(lowess(WTUP,KOUP), col="blue3", lwd=3.5)


