#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor;
print color("reset"), "Starting !!!\n\n\n";
system ("rm MANormalized_READ_INFO.txt; ls -l; sleep 3");

@SAMPLE_INFO=qw(
H3K4me3_LSD1-WT_mES_17_EA_rep2_bw1_mm9.nodup::H3K4me3_LSD1-KO_mES_03_EA_rep2_bw1_mm9.nodup::H3K4me3_EA::180
H3K4me2_LSD1-WT_mES_17_EB_rep2_bw1_mm9.nodup::H3K4me2_LSD1-KO_mES_03_EB_rep2_bw1_mm9.nodup::H3K4me2_EB::180
H3K4me1_LSD1-WT_mES_17_EC_AM39297_rep2_bw1_mm9.nodup::H3K4me1_LSD1-KO_mES_03_EC_AM39297_rep2_bw1_mm9.nodup::H3K4me1_EC_AM39297::180
H3K4me1_LSD1-WT_mES_17_EC_07436_rep2_bw1_mm9.nodup::H3K4me1_LSD1-KO_mES_03_EC_07436_rep2_bw1_mm9.nodup::H3K4me1_EC_07436::180
H3K27Ac_LSD1-WT_mES_17_EA_rep2_bw1_mm9.nodup::H3K27Ac_LSD1-KO_mES_03_EA_rep2_bw1_mm9.nodup::H3K27Ac_EA::180
H3K4me3_WT_17_mES_S5_L007_rep1_bw1_mm9.nodup::H3K4me3_KO_3_mES_S6_L007_rep1_bw1_mm9.nodup::H3K4me3_TUFTS::160
H3K4me2_WT_17_mES_S5_L004_rep1_bw1_mm9.nodup::H3K4me2_KO_3_mES_S6_L004_rep1_bw1_mm9.nodup::H3K4me2_TUFTS::160
H3K4me1_WT_17_mES_S9_L008_rep1_bw1_mm9.nodup::H3K4me1_KO_3_mES_S10_L008_rep1_bw1_mm9.nodup::H3K4me1_TUFTS::160
H3K27Ac_WT_17_mES_S7_L004_rep1_bw1_mm9.nodup::H3K27Ac_KO_3_mES_S8_L004_rep1_bw1_mm9.nodup::H3K27Ac_TUFTS::160
HDAC1_Bethyl_WT_17_mES_S1_L003_rep1_bw1_mm9.nodup::HDAC1_Bethyl_KO_3_mES_S2_L003_rep1_bw1_mm9.nodup::HDAC1_TUFTS_Bethyl::160
HDAC1_Scbt_WT_17_mES_S3_L003_rep1_bw1_mm9.nodup::HDAC1_Scbt_KO_3_mES_S4_L003_rep1_bw1_mm9.nodup::HDAC1_TUFTS_SCBT::160
BHC80_WT_17_mES_S11_L008_rep1_bw1_mm9.nodup::BHC80_KO_3_mES_S12_L008_rep1_bw1_mm9.nodup::BHC80_TUFTS::160
H3K4me1_CMA302_LSD1-WT_mES_17_EB_rep2_bw1_mm9.nodup::H3K4me1_CMA302_LSD1-KO_mES_03_EB_rep2_bw1_mm9.nodup::H3K4me1_EB_CMA302::180
H3K4me1_07436_rep2_LSD1-WT_mES_17_SF_rep4_bw1_mm9.nodup::H3K4me1_07436_rep2_LSD1-KO_mES_17_SF_rep4_bw1_mm9.nodup::H3K4me1_rep4_07436::180
H3K4me3_SMCX_WT_mES_F7_rep0_bw1_mm9.nodup::H3K4me3_SMCX_KO_mES_C5_rep0_bw1_mm9.nodup::H3K4me3_SMCX::180
H3K4me2_SMCX_WT_mES_F7_rep0_bw1_mm9.nodup::H3K4me2_SMCX_KO_mES_C5_rep0_bw1_mm9.nodup::H3K4me2_SMCX::180
H3K27Ac_AM39135_SMCX_WT_mES_F7_rep0_bw1_mm9.nodup::H3K27Ac_AM39135_SMCX_KO_mES_C5_rep0_bw1_mm9.nodup::H3K27Ac_SMCX_AM39135::180
H3K27Ac_ab4729_SMCX_WT_mES_F7_rep0_bw1_mm9.nodup::H3K27Ac_ab4729_SMCX_KO_mES_C5_rep0_bw1_mm9.nodup::H3K27Ac_SMCX_ab4729::180
AC27_H3K27Ac_COL5_LSD1-WT_mES_17_rep0_Merged_bw1_mm9.nodup::AC28_H3K27Ac_COL5_LSD1-KO_mES_03_rep0_Merged_bw1_mm9.nodup::H3K27Ac_COL5_ab4729::180
HAC1_HDAC1_Bethyl_LSD1-WT_mES_17_rep0_bw1_mm9.nodup::HAD2_HDAC1_Bethyl_LSD1-KO_mES_03_rep0_bw1_mm9.nodup::HDAC1_rep0::180
TRM3_H3K4me3_COL5_LSD1-WT_mES_17_rep0_Merged_bw1_mm9.nodup::TRM4_H3K4me3_COL5_LSD1-KO_mES_03_rep0_Merged_bw1_mm9.nodup::H3K4me3_rep0::180
);

$BED_FOLDER="/scratch/iwase-lab/SAURABH/LSD1_WT_KO_CHIPSEQ/BEDFILES";
$MANORM_FOLDER="/scratch/iwase-lab/SAURABH/LSD1_WT_KO_CHIPSEQ/MA_Norm_Analysis/MANorm_DATA";
open (READ_INFO, ">MANormalized_READ_INFO.txt");

for $x (0 .. $#SAMPLE_INFO)
{
($SAMPLE_1, $SAMPLE_2, $PREFIX, $FL) = split("::", $SAMPLE_INFO[$x]);
print color("yellow"), "\n\n", scalar localtime, "########## MA NORM COMPARISON $x\n$SAMPLE_1\n$SAMPLE_2\n$PREFIX\n", color ("cyan"), "$PREFIX ########## \n";
$MANORM_READ_1=0;$MANORM_READ_2=0;$peak_num=0;
print color ("cyan"), "CHECK MANORM_READ_1=$MANORM_READ_1\tMANORM_READ_2=$MANORM_READ_2\n";sleep 1;
open (MANORM_DATAFILE,"$MANORM_FOLDER/$PREFIX-MAnorm_result_commonPeak_merged.xls");
	LINE:while ($line=<MANORM_DATAFILE>)
	{
	chomp $line;
	($CHR,$START,$END,$DESCRIPTION,$Read1,$Read2,$Mass,$Ave,$pvalue)= split(/\t/,$line);
	if (($DESCRIPTION eq 'description') || ($DESCRIPTION eq 'unique_peak1') || ($DESCRIPTION eq 'unique_peak2')) {next LINE;}
	$MANORM_READ_1=$MANORM_READ_1+$Read1;
	$MANORM_READ_2=$MANORM_READ_2+$Read2;
	$peak_num++;
	}
	close MANORM_DATAFILE;
print color ("yellow"), "Number of Common Peaks=$peak_num\t$MANORM_READ_1\t$MANORM_READ_2\n";
$READ_NUM_1=$READ_NUM_2=0;
print color ("cyan"), "CHECK READ_NUM_1=$READ_NUM_1\tREAD_NUM_2=$READ_NUM_2\n";sleep 1;
	if ($peak_num > 100)
	{
	system ("ls -l $BED_FOLDER/$SAMPLE_1.bed.gz; ls -l $BED_FOLDER/$SAMPLE_2.bed.gz");
	$READ_NUM_1=`gunzip -c $BED_FOLDER/$SAMPLE_1.bed.gz|wc -l`; chomp $READ_NUM_1;
	$READ_NUM_2=`gunzip -c $BED_FOLDER/$SAMPLE_2.bed.gz|wc -l`; chomp $READ_NUM_2;

	$MANORM_RATIO_1=$MANORM_READ_1/$READ_NUM_1;
	$MANORM_RATIO_2=$MANORM_READ_2/$READ_NUM_2;
	$MANorm_Factor=$MANORM_RATIO_1/$MANORM_RATIO_2;

	print "$x $SAMPLE_1\t$READ_NUM_1\t$SAMPLE_2\t$READ_NUM_2\tTotal_Common_Peaks=\t$peak_num\tMANORM_READ_1\t$MANORM_READ_1\tMANORM_READ_2\t$MANORM_READ_2\tSignal in $SAMPLE_2 needs to be multiplied by Factor=\t$MANorm_Factor\n";
	print READ_INFO "$x $SAMPLE_1\t$READ_NUM_1\t$SAMPLE_2\t$READ_NUM_2\tTotal_Common_Peaks=\t$peak_num\tMANORM_READ_1\t$MANORM_READ_1\tMANORM_READ_2\t$MANORM_READ_2\tSignal in $SAMPLE_2 needs to be multiplied by Factor=\t$MANorm_Factor\n";
	}
}
close READ_INFO;
print color("reset"), "\nDone !!!\nDone !!!\nDone !!!\nDone !!!\n";

