#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor;
print color("reset"), "Starting !!!\n\n\n";

system ("rm MANorm_STATUS.txt *.bed;rm -rf MANorm_DATA; ls -l; sleep 5");

system ("cp -pvf MAnorm_Linux_R_Package/MAnorm.r ./");
system ("mkdir MANorm_DATA");
system ("ls -l; sleep 5");
open (STATUS, ">MANorm_STATUS.txt");

@SAMPLE_INFO=qw(
H3K4me3_LSD1-WT_mES_17_EA_rep2_bw1_mm9.nodup::H3K4me3_LSD1-KO_mES_03_EA_rep2_bw1_mm9.nodup::H3K4me3_EA::180
H3K4me2_LSD1-WT_mES_17_EB_rep2_bw1_mm9.nodup::H3K4me2_LSD1-KO_mES_03_EB_rep2_bw1_mm9.nodup::H3K4me2_EB::180
H3K4me1_LSD1-WT_mES_17_EC_AM39297_rep2_bw1_mm9.nodup::H3K4me1_LSD1-KO_mES_03_EC_AM39297_rep2_bw1_mm9.nodup::H3K4me1_EC_AM39297::180
H3K4me1_LSD1-WT_mES_17_EC_07436_rep2_bw1_mm9.nodup::H3K4me1_LSD1-KO_mES_03_EC_07436_rep2_bw1_mm9.nodup::H3K4me1_EC_07436::180
H3K27Ac_LSD1-WT_mES_17_EA_rep2_bw1_mm9.nodup::H3K27Ac_LSD1-KO_mES_03_EA_rep2_bw1_mm9.nodup::H3K27Ac_EA::180
H3K4me3_WT_17_mES_S5_L007_rep1_bw1_mm9.nodup::H3K4me3_KO_3_mES_S6_L007_rep1_bw1_mm9.nodup::H3K4me3_TUFTS::160
H3K4me2_WT_17_mES_S5_L004_rep1_bw1_mm9.nodup::H3K4me2_KO_3_mES_S6_L004_rep1_bw1_mm9.nodup::H3K4me2_TUFTS::160
H3K4me1_WT_17_mES_S9_L008_rep1_bw1_mm9.nodup::H3K4me1_KO_3_mES_S10_L008_rep1_bw1_mm9.nodup::H3K4me1_TUFTS::160
H3K27Ac_WT_17_mES_S7_L004_rep1_bw1_mm9.nodup::H3K27Ac_KO_3_mES_S8_L004_rep1_bw1_mm9.nodup::H3K27Ac_TUFTS::160
HDAC1_Bethyl_WT_17_mES_S1_L003_rep1_bw1_mm9.nodup::HDAC1_Bethyl_KO_3_mES_S2_L003_rep1_bw1_mm9.nodup::HDAC1_TUFTS_Bethyl::160
HDAC1_Scbt_WT_17_mES_S3_L003_rep1_bw1_mm9.nodup::HDAC1_Scbt_KO_3_mES_S4_L003_rep1_bw1_mm9.nodup::HDAC1_TUFTS_SCBT::160
BHC80_WT_17_mES_S11_L008_rep1_bw1_mm9.nodup::BHC80_KO_3_mES_S12_L008_rep1_bw1_mm9.nodup::BHC80_TUFTS::160
H3K4me1_CMA302_LSD1-WT_mES_17_EB_rep2_bw1_mm9.nodup::H3K4me1_CMA302_LSD1-KO_mES_03_EB_rep2_bw1_mm9.nodup::H3K4me1_EB_CMA302::180
H3K4me1_07436_rep2_LSD1-WT_mES_17_SF_rep4_bw1_mm9.nodup::H3K4me1_07436_rep2_LSD1-KO_mES_17_SF_rep4_bw1_mm9.nodup::H3K4me1_rep4_07436::180
H3K27Ac_AM39135_SMCX_WT_mES_F7_rep0_bw1_mm9.nodup::H3K27Ac_AM39135_SMCX_KO_mES_C5_rep0_bw1_mm9.nodup::H3K27Ac_SMCX_AM39135::180
H3K27Ac_ab4729_SMCX_WT_mES_F7_rep0_bw1_mm9.nodup::H3K27Ac_ab4729_SMCX_KO_mES_C5_rep0_bw1_mm9.nodup::H3K27Ac_SMCX_ab4729::180
);

$DIR="CREATE_REQUIRED_FILES";
$MANORM="/home/saurabha/UTILITIES/MA_Norm/MAnorm_Linux_R_Package/";
$ACTUAL_PEAK_FOLDER="/scratch/iwase-lab/SAURABH/LSD1_WT_KO_CHIPSEQ/MACS2_PEAKS";

for $x (0 .. $#SAMPLE_INFO)
{
system ("ls -l");
print STATUS `ls -l`, "\n"; 

($SAMPLE_1, $SAMPLE_2, $PREFIX, $FL) = split("::", $SAMPLE_INFO[$x]);
print color("yellow"), "\n\n", scalar localtime, "########## MA NORM COMPARISON $x\n$SAMPLE_1\n$SAMPLE_2\n$FL\n", color ("cyan"), "$PREFIX ########## \n";

$READ_FILE_1="$DIR/For_MANorm_$SAMPLE_1.BED";
$READ_FILE_2="$DIR/For_MANorm_$SAMPLE_2.BED";
print color ("green"), `ls -l $READ_FILE_1`, color ("red"). `ls -l $READ_FILE_2`, "\n";

$PEAKFILE_1="$DIR/For_MANorm_$SAMPLE_1.PEAKS";
$PEAKFILE_2="$DIR/For_MANorm_$SAMPLE_2.PEAKS";
print color ("green"), `ls -l $PEAKFILE_1`, color ("red"). `ls -l $PEAKFILE_2`;

$COMMAND="./MAnorm_2.sh $PEAKFILE_1 $PEAKFILE_2 $READ_FILE_1 $READ_FILE_2 $FL $FL";
print "\n$COMMAND\n\n";
system ("$COMMAND");
print STATUS "$x\t$COMMAND\n\n";

sleep 3;
system ("cp -pvf MAplot_before_rescaling.png MANorm_DATA/$PREFIX-MAplot_before_rescaling.png");
system ("cp -pvf MAplot_after_rescaling.png  MANorm_DATA/$PREFIX-MAplot_after_rescaling.png");
system ("cp -pvf MAnorm_result.xls  MANorm_DATA/$PREFIX-MAnorm_result.xls");
system ("cp -pvf MAnorm_result_commonPeak_merged.xls  MANorm_DATA/$PREFIX-MAnorm_result_commonPeak_merged.xls");
sleep 3;
system ("rm *.png *.xls Rcommand.out .RData *.wig *.bed *count* *read1* *read2* *peak1* *peak2*");
}

close STATUS;
print color("reset"), "\nDone !!!\nDone !!!\nDone !!!\nDone !!!\n";




#$ACTUAL_PEAK_FILE_1="$ACTUAL_PEAK_FOLDER/$SAMPLE_1"."_p1e-8_m10-50_peaks.xls"; print "$SAMPLE_1\tLength=";system ("cat $ACTUAL_PEAK_FILE_1|grep '# d'"); $ACTUAL_PEAK_FILE_2="$ACTUAL_PEAK_FOLDER/$SAMPLE_2"."_p1e-8_m10-50_peaks.xls"; print "$SAMPLE_2\tLength=";system ("cat $ACTUAL_PEAK_FILE_2|grep '# d'");


