#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor;
print color("reset"), "Starting !!!\n\n\n";

$BED_FOLDER="/scratch/iwase-lab/SAURABH/LSD1_WT_KO_CHIPSEQ/BEDFILES";
$PEAK_FOLDER="/scratch/iwase-lab/SAURABH/LSD1_WT_KO_CHIPSEQ/MACS2_PEAKS";

system ("rm MANorm_STATUS.txt; ls -l; rm *.bed; ls -l /dev/shm/");
#open (STATUS, ">MANorm_STATUS.txt");

$PEAK_SUFFIX="_p1e-8_m10-50_peaks";
@SAMPLE_INFO=qw(
H3K4me3_LSD1-WT_mES_17_EA_rep2_bw1_mm9.nodup::H3K4me3_LSD1-KO_mES_03_EA_rep2_bw1_mm9.nodup
H3K4me2_LSD1-WT_mES_17_EB_rep2_bw1_mm9.nodup::H3K4me2_LSD1-KO_mES_03_EB_rep2_bw1_mm9.nodup
H3K4me1_LSD1-WT_mES_17_EC_AM39297_rep2_bw1_mm9.nodup::H3K4me1_LSD1-KO_mES_03_EC_AM39297_rep2_bw1_mm9.nodup
H3K4me1_LSD1-WT_mES_17_EC_07436_rep2_bw1_mm9.nodup::H3K4me1_LSD1-KO_mES_03_EC_07436_rep2_bw1_mm9.nodup
H3K4me3_WT_17_mES_S5_L007_rep1_bw1_mm9.nodup::H3K4me3_KO_3_mES_S6_L007_rep1_bw1_mm9.nodup
H3K4me2_WT_17_mES_S5_L004_rep1_bw1_mm9.nodup::H3K4me2_KO_3_mES_S6_L004_rep1_bw1_mm9.nodup
H3K4me1_WT_17_mES_S9_L008_rep1_bw1_mm9.nodup::H3K4me1_KO_3_mES_S10_L008_rep1_bw1_mm9.nodup
H3K27Ac_WT_17_mES_S7_L004_rep1_bw1_mm9.nodup::H3K27Ac_KO_3_mES_S8_L004_rep1_bw1_mm9.nodup
HDAC1_Bethyl_WT_17_mES_S1_L003_rep1_bw1_mm9.nodup::HDAC1_Bethyl_KO_3_mES_S2_L003_rep1_bw1_mm9.nodup
HDAC1_Scbt_WT_17_mES_S3_L003_rep1_bw1_mm9.nodup::HDAC1_Scbt_KO_3_mES_S4_L003_rep1_bw1_mm9.nodup
BHC80_WT_17_mES_S11_L008_rep1_bw1_mm9.nodup::BHC80_KO_3_mES_S12_L008_rep1_bw1_mm9.nodup
H3K4me1_CMA302_LSD1-WT_mES_17_EB_rep2_bw1_mm9.nodup::H3K4me1_CMA302_LSD1-KO_mES_03_EB_rep2_bw1_mm9.nodup
H3K4me1_07436_rep2_LSD1-WT_mES_17_SF_rep4_bw1_mm9.nodup::H3K4me1_07436_rep2_LSD1-KO_mES_17_SF_rep4_bw1_mm9.nodup
H3K27Ac_LSD1-WT_mES_17_EA_rep2_bw1_mm9.nodup::H3K27Ac_LSD1-KO_mES_03_EA_rep2_bw1_mm9.nodup
H3K4me3_SMCX_WT_mES_F7_rep0_bw1_mm9.nodup::H3K4me3_SMCX_KO_mES_C5_rep0_bw1_mm9.nodup
H3K4me2_SMCX_WT_mES_F7_rep0_bw1_mm9.nodup::H3K4me2_SMCX_KO_mES_C5_rep0_bw1_mm9.nodup
H3K27Ac_AM39135_SMCX_WT_mES_F7_rep0_bw1_mm9.nodup::H3K27Ac_AM39135_SMCX_KO_mES_C5_rep0_bw1_mm9.nodup
H3K27Ac_ab4729_SMCX_WT_mES_F7_rep0_bw1_mm9.nodup::H3K27Ac_ab4729_SMCX_KO_mES_C5_rep0_bw1_mm9.nodup
AC27_H3K27Ac_COL5_LSD1-WT_mES_17_rep0_Merged_bw1_mm9.nodup::AC28_H3K27Ac_COL5_LSD1-KO_mES_03_rep0_Merged_bw1_mm9.nodup
HAC1_HDAC1_Bethyl_LSD1-WT_mES_17_rep0_bw1_mm9.nodup::HAD2_HDAC1_Bethyl_LSD1-KO_mES_03_rep0_bw1_mm9.nodup
TRM3_H3K4me3_COL5_LSD1-WT_mES_17_rep0_Merged_bw1_mm9.nodup::TRM4_H3K4me3_COL5_LSD1-KO_mES_03_rep0_Merged_bw1_mm9.nodup
);

$MANORM_BED_FOLDER="/scratch/iwase-lab/SAURABH/LSD1_WT_KO_CHIPSEQ/MA_Norm_Analysis/CREATE_REQUIRED_FILES";

for $x (0 .. $#SAMPLE_INFO)
{
($SAMPLE_1, $SAMPLE_2) = split("::", $SAMPLE_INFO[$x]);
print color("yellow"), scalar localtime, "######## COMPARISON $x\n$SAMPLE_1\n$SAMPLE_2\n";
##### PREPARING BED FILES #######
print color ("green"), `ls -l $BED_FOLDER/$SAMPLE_1.bed.gz`, color ("red"). `ls -l $BED_FOLDER/$SAMPLE_2.bed.gz`;
system ("gunzip -c $BED_FOLDER/$SAMPLE_1.bed.gz |cut -f 1,2,3,6 > For_MANorm_$SAMPLE_1.BED &"); sleep 3; 
system ("gunzip -c $BED_FOLDER/$SAMPLE_2.bed.gz |cut -f 1,2,3,6 > For_MANorm_$SAMPLE_2.BED");

##### PREPARING PEAK FILES #######
$PEAKFILE_1="$PEAK_FOLDER/$SAMPLE_1".$PEAK_SUFFIX;
$PEAKFILE_2="$PEAK_FOLDER/$SAMPLE_2".$PEAK_SUFFIX;
print color ("cyan"), `ls -l $PEAKFILE_1.narrowPeak`, color ("magenta"). `ls -l $PEAKFILE_2.narrowPeak`;
system ("cat $PEAKFILE_1.narrowPeak |cut -f 1,2,3 > For_MANorm_$SAMPLE_1.PEAKS");
system ("cat $PEAKFILE_2.narrowPeak |cut -f 1,2,3 > For_MANorm_$SAMPLE_2.PEAKS");
sleep 3;
}

print "$BED_FOLDER/$SAMPLE_1.bed.gz\n$PEAKFILE_1.narrowPeak\n";
#close STATUS;
print color("reset"), "\nDone !!!\nDone !!!\nDone !!!\nDone !!!\n";
