#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 

$STATUS="BOWTIE_LSD1_WT_KO_mES_TUFTS_DATA_STATUS.txt";
system ("rm *.bam *.bedgraph *.bw; ls -l; sleep 5");

system ("rm $STATUS");
print color ("reset"), "\n\n\n"; sleep 1; 
system ("ls -l");

open (STDERR,">$STATUS");
open (MARKLIST,">List_Of_Names.txt");

print color ("reset"), "\n", $ENV{'PATH'};
print "\n-------------------------------------------------------\n"; sleep 1;
system ("samtools --version; bowtie --version");
print "-------------------------------------------------------\n"; sleep 2;

$WigToBigwig="/home/saurabha/UTILITIES/UCSC/wigToBigWig";

#######
$MM9_FOLDER="/scratch/iwase-lab/SAURABH/GENOMES/MM9";
$MM9_FASTA="$MM9_FOLDER/mm9.fa";
$MM9_FaFai="$MM9_FOLDER/mm9.fa.fai";
$MM9_CHROM_SIZES="$MM9_FOLDER/mm9.chrom.sizes";
$MM9_BOWTIE_1_Index="/scratch/iwase-lab/SAURABH/GENOME_INDICES/MM9/MM9_BOWTIE_1/mm9_bowtie112";

########## MAPPING ##############
$BOWTIE="bowtie"; 
$MM9_INDEX=$MM9_BOWTIE_1_Index;

$BOWTIE_OPTIONS = " -v 2 -m 1 --best --strata -S --time -p 15";
system ("echo date STARTING > READ_COUNTS.txt");
$SAMPLE_FOLDER="/scratch/iwase-lab/SAURABH/LSD1_WT_KO_CHIPSEQ/LSD1_CHIPSEQ_TUFTS/FASTQ_FILES";
$REPLICATE="rep1";

@SAMPLES=qw(H3K4me2_WT_17_mES_S5_L004
H3K4me2_KO_3_mES_S6_L004
H3K4me3_WT_17_mES_S5_L007
H3K4me3_KO_3_mES_S6_L007
H3K27Ac_WT_17_mES_S7_L004
H3K27Ac_KO_3_mES_S8_L004
H3K4me1_KO_3_mES_S10_L008
H3K4me1_WT_17_mES_S9_L008
HDAC1_Bethyl_WT_17_mES_S1_L003
HDAC1_Bethyl_KO_3_mES_S2_L003
HDAC1_Scbt_WT_17_mES_S3_L003
HDAC1_Scbt_KO_3_mES_S4_L003
BHC80_KO_3_mES_S12_L008
BHC80_WT_17_mES_S11_L008
Input_31_KO_3_mES_S2_L006
Input_171_WT_17_mES_S1_L006
Supernatant_32_KO_3_mES_S4_L006
Supernatant_172_WT_17_mES_S3_L006
No_Antibody_WT_17_mES_S7_L007
No_Antibody_KO_3_mES_S8_L007
);

for $x (0 .. $#SAMPLES) 
{
$SAMPLE=$SAMPLES[$x];

$READS="$SAMPLE_FOLDER/$SAMPLE"."_R1_001.fastq.gz";
$root=$SAMPLE."_".$REPLICATE."_bw1_mm9";
print color ("yellow"), "##############\n $x ##### $root $READS\n";
print STDERR "\n############## $x ############## $x $root $READS\n";
print MARKLIST "$root ";
system ("ls -lh $READS");

$BOWTIE_COMMAND="gzip -cd $READS| $BOWTIE $BOWTIE_OPTIONS $MM9_INDEX - | samtools view -F 0x4 -ub -t $MM9_FaFai |samtools sort -m 64G -@ 10 - -o Sorted_$root.bam";
print STDERR "$x\n$BOWTIE_COMMAND\n";
system ("$BOWTIE_COMMAND");

$NODUP_COMMAND="samtools view -F 0x4 -ub Sorted_$root.bam | samtools rmdup -s --output-fmt-option nthreads=8 - $root.nodup.bam";
print STDERR "$NODUP_COMMAND\n";
system ("$NODUP_COMMAND");

$BAMFILE="$root.nodup.bam";
#Indexing
$INDEX_COMMAND="samtools index $BAMFILE";
print STDERR "$INDEX_COMMAND\n";
system ("$INDEX_COMMAND");

sleep 3;

##### READ COUNTING #####
system ("echo $root>> READ_COUNTS.txt");	
system ("echo Total >> READ_COUNTS.txt");	
$IDXSTATS_COMMAND="";
print "$IDXSTATS_COMMAND\n";
system("samtools idxstats $BAMFILE | awk \'BEGIN {a=0} {a += \$3} END{print a}\' >> READ_COUNTS.txt");
system ("echo Ribosomal >> READ_COUNTS.txt");	 system("samtools view -c $BAMFILE chr17:39978942-39986774 >> READ_COUNTS.txt");
system ("echo Mitochondrial >> READ_COUNTS.txt");system("samtools view -c $BAMFILE chrM >> READ_COUNTS.txt");
sleep 5;
}

close STDERR;
close LANE_INFO;
print color ("yellow")," BOWTIE FINISHED ON ALL\nDONE !!!\nDONE !!!\nDONE !!!\nDONE !!!\nDONE !!!\n", color("reset");

