#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 

open (STDERR, ">MACS2_p300_STATUS.txt");
system ("rm -f /dev/shm/*.bam; rm -f MACS2_p300_STATUS.txt; ls -l; sleep 3;ls -l /dev/shm/");
print "\n\n\n";
#########################
$SMCX_1="/scratch/iwase-lab/SAURABH/ALL_EMILY_mES_DATA/BOWTIE_1/JARID1c_SMCX_WT_mES_F7_rep1_bw1_mm9.nodup.bam";
$SMCX_2="/scratch/iwase-lab/SAURABH/ALL_EMILY_mES_DATA/SMCX_SMCX_mES_ChIPSeq/KDM5c_ChIPSeq_SMCX_mESCWT-FIX2_bw1_mm9.nodup.bam";
$SMCX_3="Merged_KDM5c_SMCX_WT_mES_rep12_bw1_mm9.nodup.bam";
$MERGE_COMMAND="samtools merge -urf - $SMCX_1 $SMCX_2 |samtools sort -@ 10 -m 128G - -o $SMCX_3";
#system ("$MERGE_COMMAND");
system ("ls -l $SMCX_1 $SMCX_2 $SMCX_3; sleep 5;");

#########################
system ("cp -pvf /scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/BAM_FILES/INPUT_WT_mES.bam /dev/shm/; sleep 3");
system ("cp -pvf $SMCX_1 $SMCX_2 $SMCX_3 /dev/shm/; sleep 3");

print "\n\n\n";
system ("sleep 3; ls -l /dev/shm/; sleep 15");

@INPUT=("","-c /dev/shm/INPUT_WT_mES.bam");
@SUFFIX=qw(Input_None Input_Merged_All);

@Q_VALUES=qw(0.01 0.02 0.05);
@KDM5c_BAMS=qw(JARID1c_SMCX_WT_mES_F7_rep1_bw1_mm9 KDM5c_ChIPSeq_SMCX_mESCWT-FIX2_bw1_mm9 Merged_KDM5c_SMCX_WT_mES_rep12_bw1_mm9);

for $x (0 .. 2)
{
$TEST=$KDM5c_BAMS[$x];
$TEST_BAM="/dev/shm/$TEST.nodup.bam";
print color("cyan"),"$x",`ls -l $TEST_BAM`;

for $y (0 .. $#Q_VALUES)
{
$Q=$Q_VALUES[$y];

for $z (0 .. 1)
{
$OUTFILE=$TEST."_".$SUFFIX[$z]."_q_$Q";

print color ("yellow"), "\n\n\n", scalar localtime, "   ###### $x\t$y\t$z\t$TEST\t$TEST_BAM\tq=$Q\n$INPUT[$z]\n$OUTFILE\n", color ("magenta");
print "CONTROL_FILE=$CONTROL\n",color("reset");

$MACS2_COMMAND="macs2 callpeak -f BAM -g 1.87e9 -q $Q -t /dev/shm/$TEST.nodup.bam $INPUT[$z] -n $OUTFILE"; 
print STDERR "###### $n ######\n$MACS2_COMMAND\n\n";
print color ("green"), "$MACS2_COMMAND\n\n";

system ("module load macs2/2.1.0.20140616; sleep 3; nohup $MACS2_COMMAND > $OUTFILE.out &");
sleep 15;
}}}


print color("reset"), "\nDone !!!\nDone !!!\nDone !!!\nDone !!!\n";
