#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 

$FOLDER="/scratch/iwase-lab/SAURABH/CORRELATION/Equal_Reads/COVERAGE/RAW_COVERAGE";

@SAMPLE_INFO=qw(
INPUT_WT_mES:::207.965310:::1000
H3K4me1:::40:::1000
H3K4me2:::40:::1000
H3K4me3:::40:::1000
H3K27Ac:::40:::1000
H3K27me3:::80:::1000
H3K9Ac:::40:::1000
H3K9me3:::80:::1000
LSD1:::22.853847:::450
KDM5C:::50.194774:::450
p300:::29.988265:::450);

$LIST_OF_FILES="";
for $x (0 .. $#SAMPLE_INFO)
{
($MARK,$T,$WIDTH)=split(":::",$SAMPLE_INFO[$x]);
$TOTAL{"$MARK"}=$T;
$FILE="$FOLDER/RAW_$MARK.$WIDTH.coverage";
system ("ls -l $FILE");
$LIST_OF_FILES=$LIST_OF_FILES." $FILE";
}

print "$TOTAL{'H3K4me1'}\t$TOTAL{'H3K4me2'}\t$TOTAL{'H3K4me3'}\t$TOTAL{'H3K27Ac'}\t$TOTAL{'H3K27me3'}\t$TOTAL{'H3K9Ac'}\t$TOTAL{'H3K9me3'}\t$TOTAL{'LSD1'}\t$TOTAL{'KDM5C'}\t$TOTAL{'p300'}\n";


system ("paste $LIST_OF_FILES > MERGED_COVERGAE_INTERMEDIATE.txt");

open (RAW_COVERAGE,"MERGED_COVERGAE_INTERMEDIATE.txt");
open (NORM_COVERAGE,">NORM_COVERGAE_MERGED.txt");
print NORM_COVERAGE "Enhancer_ID\tINPUT\tH3K4me1\tH3K4me2\tH3K4me3\tH3K27Ac\tH3K27me3\tH3K9Ac\tH3K9me3\tLSD1\tKDM5C\tp300\n";
open (LOG_COVERAGE, ">LOG_COVERGAE_MERGED.txt");
print LOG_COVERAGE "Enhancer_ID\tINPUT\tH3K4me1\tH3K4me2\tH3K4me3\tH3K27Ac\tH3K27me3\tH3K9Ac\tH3K9me3\tLSD1\tKDM5C\tp300\n";

while ($line=<RAW_COVERAGE>)
{
chomp $line;
@V=split("\t",$line);
$ID=$V[3];
if (($ID ne $V[3]) || ($ID ne $V[10]) || ($ID ne $V[17]) || ($ID ne $V[24]) || ($ID ne $V[31]) || ($ID ne $V[38]) || ($ID ne $V[45]) || ($ID ne $V[52]) || ($ID ne $V[59]) || ($ID ne $V[66]) || ($ID ne $V[73])) {die "Values do not match";}  

$INPUT=$V[6]/207.965310;
$H3K4me1=	($V[13]/$TOTAL{"H3K4me1"} +0.01)/($INPUT+0.01);
$H3K4me2=	($V[20]/$TOTAL{"H3K4me2"} +0.01)/($INPUT+0.01);
$H3K4me3=	($V[27]/$TOTAL{"H3K4me3"} +0.01)/($INPUT+0.01);
$H3K27Ac=	($V[34]/$TOTAL{"H3K27Ac"} +0.01)/($INPUT+0.01);
$H3K27me3=	($V[41]/$TOTAL{"H3K27me3"}+0.01)/($INPUT+0.01);
$H3K9Ac=	($V[48]/$TOTAL{"H3K9Ac"}  +0.01)/($INPUT+0.01);
$H3K9me3=	($V[55]/$TOTAL{"H3K9me3"} +0.01)/($INPUT+0.01);
$LSD1=		($V[62]/$TOTAL{"LSD1"}    +0.01)/($INPUT+0.01);
$KDM5C=		($V[69]/$TOTAL{"KDM5C"}   +0.01)/($INPUT+0.01);
$p300=		($V[76]/$TOTAL{"p300"}    +0.01)/($INPUT+0.01);

print NORM_COVERAGE "$ID\t$INPUT\t$H3K4me1\t$H3K4me2\t$H3K4me3\t$H3K27Ac\t$H3K27me3\t$H3K9Ac\t$H3K9me3\t$LSD1\t$KDM5C\t$p300\n";


$H3K4me1	=log($H3K4me1)/log(2);
$H3K4me2	=log($H3K4me2)/log(2);
$H3K4me3	=log($H3K4me3)/log(2);
$H3K27Ac	=log($H3K27Ac)/log(2);
$H3K27me3	=log($H3K27me3)/log(2);
$H3K9Ac		=log($H3K9Ac)/log(2);
$H3K9me3	=log($H3K9me3)/log(2);
$LSD1		=log($LSD1)/log(2);
$KDM5C		=log($KDM5C)/log(2);
$p300		=log($p300)/log(2);

print LOG_COVERAGE "$ID\t$INPUT\t$H3K4me1\t$H3K4me2\t$H3K4me3\t$H3K27Ac\t$H3K27me3\t$H3K9Ac\t$H3K9me3\t$LSD1\t$KDM5C\t$p300\n";
}
close LOG_COVERAGE;
close NORM_COVERAGE;
close RAW_COVERAGE;

