#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 
system ("rm -rf RAW_COVERAGE NORMALIZED_COVERAGE *.bed; ls -l; sleep 3");
system ("mkdir RAW_COVERAGE NORMALIZED_COVERAGE");

##############
$SAF_FILE="/scratch/iwase-lab/SAURABH/CORRELATION/GETTING_DHS/Valid_Intergenic_DHS_SAF_1000bp.SAF";

open (DHS_SITES,"$SAF_FILE");
open (ENHANCER_BED_1000,">ALL_ENHANCERS_INFO_FOR_COVERAGE_1000.bed");
open (ENHANCER_BED_750,">ALL_ENHANCERS_INFO_FOR_COVERAGE_750.bed");
open (ENHANCER_BED_450,">ALL_ENHANCERS_INFO_FOR_COVERAGE_450.bed");

NEXT_DHS:while ($line = <DHS_SITES>)
{
chomp $line;
($ID,$CHR,$L,$R,$S)=split("\t",$line);
if ($ID eq 'GeneID') {next NEXT_DHS;}

$SUMMIT=int($L+$R)/2;
$LEFT=$SUMMIT-1000; $RIGHT=$SUMMIT+1000;
print ENHANCER_BED_1000"$CHR\t$LEFT\t$RIGHT\t$ID\t255\t.\n";

$LEFT=$SUMMIT-750; $RIGHT=$SUMMIT+750;
print ENHANCER_BED_750 "$CHR\t$LEFT\t$RIGHT\t$ID\t255\t.\n";

$LEFT=$SUMMIT-450; $RIGHT=$SUMMIT+450;
print ENHANCER_BED_450 "$CHR\t$LEFT\t$RIGHT\t$ID\t255\t.\n";
}
close ENHANCER_INFO;
close ENHANCER_BED_1000;
close ENHANCER_BED_450;
close ENHANCER_BED_750;

system ("wc -l $SAF_FILE ALL_ENHANCERS_INFO_*.bed");
system ("head -n 5 ALL_ENHANCERS_INFO_*.bed");
sleep 3;
##############
@SAMPLE_INFO=qw(
H3K27Ac:::40000000
H3K27me3:::80000000
H3K4me1:::40000000
H3K4me2:::40000000
H3K4me3:::40000000
H3K9Ac:::40000000
H3K9me3:::80000000
INPUT_WT_mES:::207965310
LSD1:::22853847
KDM5C:::50194774
p300:::29988265);

@WIDTHS=qw(1000 750 450);

for $x (0 .. $#SAMPLE_INFO)
{
($MARK,$TOTAL)=split(":::",$SAMPLE_INFO[$x]);
$T=$TOTAL/1000000;

$BEDFILE="/scratch/iwase-lab/SAURABH/CORRELATION/Equal_Reads/Extended_BED_FILES/Sorted_Extended_$MARK.bed.gz";
system ("ls -l $BEDFILE");
print "\n\n\n$x\t$TOTAL\t$T\n";

for $w (0 .. 2)
{
$WIDTH=$WIDTHS[$w];
$WIDTHKB=2*$WIDTH/1000;
$BED_INFORMATION="ALL_ENHANCERS_INFO_FOR_COVERAGE_$WIDTH.bed";
print "$w\t$WIDTH\t$WIDTHKB\t$BED_INFORMATION\n";

system("gzip -cd $BEDFILE | bedtools coverage -mean -a $BED_INFORMATION -b stdin > RAW_COVERAGE/RAW_$MARK.$WIDTH.coverage");
#########################
$FILE="$MARK.$WIDTH.coverage";
open (COVERAGE_IN,"RAW_COVERAGE/RAW_$FILE");
open (COVERAGE_OUT,">NORMALIZED_COVERAGE/NORM_$FILE");
$LIST_OF_FILES=$LIST_OF_FILES." NORMALIZED_COVERAGE/NORM_$FILE";

print COVERAGE_OUT "ENHANCER_ID\t$MARK.$WIDTH\n"; 
$ln=0;
while ($line = <COVERAGE_IN>)
{
chomp $line;
$ln++;
($C,$L,$R,$ENHANCER_ID,$S1,$S2,$COVERAGE)=split("\t",$line);
$CHECK_ID[$x][$ln]=$ENHANCER_ID; if ($ENHANCER_ID ne $CHECK_ID[0][$ln]) {die "Enhancer IDs do not match";}

$RPKM=$COVERAGE/($T*$WIDTHKB);
print COVERAGE_OUT "$ENHANCER_ID\t$RPKM\n";
}
close COVERAGE_IN; close COVERAGE_OUT;
sleep 1;
system ("head -n 5 NORMALIZED_COVERAGE/NORM_$FILE");
}
}
system ("paste $LIST_OF_FILES > NORM_COVERAGE_ALL_SAMPLES.coverage");

