#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor;
use List::Util qw(min max);

$TOTAL_INPUT   =138.515690206529;
$TOTAL_H3K27Ac =58.4398540972685;
$TOTAL_H3K27me3=98.2313351099267;
$TOTAL_H3K9Ac  =28.4421299133911;
$TOTAL_H3K9me3 =64.362273817455;

open (ENHANCER_INFO,"/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/Active_Vs_Poised/ESTIMATION/ENHANCER_READ_COUNTS_FOR_ACTIVE_vs_POISED.estimation");
open (ENHANCER_INFO_OUT,">ACTIVE_vs_POISED_mES_Enhancers.txt");
print ENHANCER_INFO_OUT "ENHANCER_ID\tTYPE\tLSD1_BINDING\tLOG2CHANGE\tpadj\tSIGNIFICANCE\tGROSEQ_WT\tGROSEQ_KO\tGROSEQ_STATUS\tK27_STATUS\tK9_STATUS\tLOCATION\n";

$n=0;
NEXT_ENHANCER:while ($line = <ENHANCER_INFO>)
{
$n++;
chomp $line;
if ($n eq 1) {next NEXT_ENHANCER;}
($ID,$INPUT,$H3K27Ac,$H3K27me3,$H3K9Ac,$H3K9me3)=split("\t",$line);

$INPUT     = $INPUT/$TOTAL_INPUT;

$H3K27Ac   = $H3K27Ac/($TOTAL_H3K27Ac*$INPUT);
$H3K27me3  = $H3K27me3/($TOTAL_H3K27me3*$INPUT);
$H3K9Ac    = $H3K9Ac/($TOTAL_H3K9Ac*$INPUT);
$H3K9me3   = $H3K9me3/($TOTAL_H3K9me3*$INPUT);

($ENHANCER_ID,$TYPE,$LSD1_BINDING,$LOG2CHANGE,$padj,$baseMeanA,$baseMeanB)=split("!!!",$ID);

($P300_or_DHS_num,$chr,$summit)=split(":::",$ENHANCER_ID);
$L=$summit-10000;$R=$summit+10000;$LOCATION="$chr:$L-$R";

$NORM_GROSEQ=$baseMeanA;
$SIGNIFICANCE="INSIG";
if (($LOG2CHANGE > 0) && ($padj < 0.05)) {$SIGNIFICANCE="SIG_UP";}
if (($LOG2CHANGE < 0) && ($padj < 0.05)) {$SIGNIFICANCE="SIG_DOWN";}


$GROSEQ_STATUS="";
if ($NORM_GROSEQ < 4.19)                                 {$VERY_LOW_GROSEQ++;$GROSEQ_STATUS="A_VERY_LOW_GROSEQ";goto CHECK_K27;}
if (($NORM_GROSEQ >= 4.19)   && ($NORM_GROSEQ < 18.14))  {$LOW_GROSEQ++;     $GROSEQ_STATUS="B_LOW_GROSEQ";     goto CHECK_K27;}
if (($NORM_GROSEQ >= 18.14)  && ($NORM_GROSEQ < 65.57))  {$MED_GROSEQ++;     $GROSEQ_STATUS="C_MED_GROSEQ";     goto CHECK_K27;}
if ($NORM_GROSEQ >= 65.57)                               {$HIGH_GROSEQ++;    $GROSEQ_STATUS="D_HIGH_GROSEQ";    goto CHECK_K27;}

#Poised Enhancers according to H3K27
CHECK_K27:$K27_STATUS="F_K27_INTERMEDIATE";
if (($H3K27Ac > 2)  && ($H3K27Ac/$H3K27me3 > 2))                            {$K27_STATUS="G_K27_ACTIVE";  $ACTIVITY_K27_ACTIVE++;goto CHECK_K9;}
if (($H3K27Ac <= 1) && ($H3K27me3 > 1.2))				    {$K27_STATUS="E_K27_POISED";$ACTIVITY_K27_POISED_1++;goto CHECK_K9;}
if ($K27_STATUS eq "F_K27_INTERMEDIATE")                                    {$ACTIVITY_K27_INTERMEDIATE++;}

#Poised Enhancers according to H3K9
CHECK_K9: $K9_STATUS="I_K9_INTERMEDIATE";
if (($H3K9Ac > 2)   && ($H3K9Ac/$H3K9me3 > 2))                              {$K9_STATUS="J_K9_ACTIVE";$ACTIVITY_K9_ACTIVE++;  goto PRINT_VALUES;}
if (($H3K9Ac <= 1)  && ($H3K9me3 > 1.2))                                   {$K9_STATUS="H_K9_POISED";$ACTIVITY_K9_POISED_1++;goto PRINT_VALUES;}
if ($K9_STATUS eq "I_K9_INTERMEDIATE")                                      {$ACTIVITY_K9_INTERMEDIATE++;}

PRINT_VALUES:print ENHANCER_INFO_OUT "$ENHANCER_ID\t$TYPE\t$LSD1_BINDING\t$LOG2CHANGE\t$padj\t$SIGNIFICANCE\t$baseMeanA\t$baseMeanB\t$GROSEQ_STATUS\t$K27_STATUS\t$K9_STATUS\t$LOCATION\n";
}
close LIST_OF_ENHANCERS;
close ENHANCER_INFO_OUT;

###################################
print color ("yellow"),"GROSEQ\nVERY_LOW_GROSEQ=$VERY_LOW_GROSEQ\nLOW_GROSEQ=$LOW_GROSEQ\nMED_GROSEQ=$MED_GROSEQ\nHIGH_GROSEQ=$HIGH_GROSEQ\n\n\n";
print "K27\nACTIVE=$ACTIVITY_K27_ACTIVE\nPOISED_1=$ACTIVITY_K27_POISED_1\nPOISED_2=$ACTIVITY_K27_POISED_2\nINTERMEDIATE=$ACTIVITY_K27_INTERMEDIATE\n\n\n";
print "K9\nACTIVE=$ACTIVITY_K9_ACTIVE\nPOISED_1=$ACTIVITY_K9_POISED_1\nPOISED_2=$ACTIVITY_K9_POISED_2\nINTERMEDIATE=$ACTIVITY_K9_INTERMEDIATE\n\n\n";

system ("cat ACTIVE_vs_POISED_mES_Enhancers.txt |grep LSD1_BOUND_ENHANCERS  |grep SIG_UP  |wc -l");
system ("cat ACTIVE_vs_POISED_mES_Enhancers.txt |grep LSD1_BOUND_ENHANCERS  |grep SIG_DOWN|wc -l");

system ("cat ACTIVE_vs_POISED_mES_Enhancers.txt |grep LSD1_UNBOUND_ENHANCERS|grep SIG_UP  |wc -l");
system ("cat ACTIVE_vs_POISED_mES_Enhancers.txt |grep LSD1_UNBOUND_ENHANCERS|grep SIG_DOWN|wc -l");


system ("cat ACTIVE_vs_POISED_mES_Enhancers.txt |grep LSD1_BOUND_ENHANCERS   > LSD1_BOUND_ACTIVE_vs_POISED_mES_Enhancers.txt");
system ("cat ACTIVE_vs_POISED_mES_Enhancers.txt |grep LSD1_UNBOUND_ENHANCERS > LSD1_UNBOUND_ACTIVE_vs_POISED_mES_Enhancers.txt");
###################################
@CATEGORIES=qw(A_VERY_LOW_GROSEQ B_LOW_GROSEQ C_MED_GROSEQ D_HIGH_GROSEQ K27_POISED K27_INTERMEDIATE K27_ACTIVE K9_POISED K9_INTERMEDIATE K9_ACTIVE);
@BOUND_UNBOUND=qw(LSD1_BOUND_ENHANCERS LSD1_UNBOUND_ENHANCERS);

for $y (0 .. 1)
{
$BINDING=$BOUND_UNBOUND[$y];
for $x (0 .. $#CATEGORIES)
{
$CATEGORY=$CATEGORIES[$x];
print color ("cyan"), "$BINDING\t$CATEGORY\n", color("yellow");
print "ALL=",     `cat ACTIVE_vs_POISED_mES_Enhancers.txt |grep $BINDING |grep $CATEGORY|wc -l`;
print "SIG_UP=",  `cat ACTIVE_vs_POISED_mES_Enhancers.txt |grep $BINDING |grep $CATEGORY|grep SIG_UP|wc -l`;
print "SIG_DOWN=",`cat ACTIVE_vs_POISED_mES_Enhancers.txt |grep $BINDING |grep $CATEGORY|grep SIG_DOWN|wc -l`;
print "\n\n";
}
}

###################################
open (ENHANCER_VALUES,"ACTIVE_vs_POISED_mES_Enhancers.txt");
open (ENHANCER_VALUES_FOR_BOXPLOT,">ACTIVE_vs_POISED_mES_Enhancers_FOR_BOXPLOT.txt");
print ENHANCER_VALUES_FOR_BOXPLOT "value\tfeature\n";
$n=0;
@WIL_TYPES=qw(A_VERY_LOW_GROSEQ B_LOW_GROSEQ C_MED_GROSEQ D_HIGH_GROSEQ E_K27_POISED F_K27_INTERMEDIATE G_K27_ACTIVE  H_K9_POISED I_K9_INTERMEDIATE J_K9_ACTIVE);

for $T (0 .. $#WIL_TYPES) {$FILEHANDLE="FOR_WILCOXON_$WIL_TYPES[$T]"; open ($FILEHANDLE,">FOR_WILCOXON_$WIL_TYPES[$T].wil");}

NEXT_VALUE:while ($line = <ENHANCER_VALUES>)
{
$n++;
chomp $line;
if ($n eq 1) {next NEXT_VALUE;}
($ENHANCER_ID,$TYPE,$LSD1_BINDING,$LOG2CHANGE,$padj,$SIGNIFICANCE,$baseMeanA,$baseMeanB,$GROSEQ_STATUS,$K27_STATUS,$K9_STATUS,$LOCATION)=split("\t",$line);

if ($LSD1_BINDING eq 'LSD1_BOUND_ENHANCERS')   {$BIND[0]="LSD1_BOUND_";}
if ($LSD1_BINDING eq 'LSD1_UNBOUND_ENHANCERS') {$BIND[0]="LSD1_UNBOUND_";}
$NF=0.016941728;
$WT_GROSEQ=log(($baseMeanA*$NF)+0.001)/log(10);
$KO_GROSEQ=log(($baseMeanB*$NF)+0.001)/log(10);
$CHANGE=$KO_GROSEQ-$WT_GROSEQ;

print ENHANCER_VALUES_FOR_BOXPLOT "$WT_GROSEQ\t$BIND[0]$GROSEQ_STATUS","_A_WT\n";;
print ENHANCER_VALUES_FOR_BOXPLOT "$KO_GROSEQ\t$BIND[0]$GROSEQ_STATUS","_B_KO\n";
#print ENHANCER_VALUES_FOR_BOXPLOT "$CHANGE\t$BIND[0]$GROSEQ_STATUS","_C_CHANGE\n";
print ENHANCER_VALUES_FOR_BOXPLOT "\t$BIND[0]$GROSEQ_STATUS","_D_GAP\n";

print ENHANCER_VALUES_FOR_BOXPLOT "$WT_GROSEQ\t$BIND[0]$K27_STATUS","_E_WT\n";
print ENHANCER_VALUES_FOR_BOXPLOT "$KO_GROSEQ\t$BIND[0]$K27_STATUS","_F_KO\n";
#print ENHANCER_VALUES_FOR_BOXPLOT "$CHANGE\t$BIND[0]$K27_STATUS","_G_CHANGE\n";
print ENHANCER_VALUES_FOR_BOXPLOT "\t$BIND[0]$K27_STATUS","_H_GAP\n";

print ENHANCER_VALUES_FOR_BOXPLOT "$WT_GROSEQ\t$BIND[0]$K9_STATUS","_I_WT\n";
print ENHANCER_VALUES_FOR_BOXPLOT "$KO_GROSEQ\t$BIND[0]$K9_STATUS","_J_KO\n";
#print ENHANCER_VALUES_FOR_BOXPLOT "$CHANGE\t$BIND[0]$K9_STATUS","_K_CHANGE\n";
print ENHANCER_VALUES_FOR_BOXPLOT "\t$BIND[0]$K9_STATUS","_L_GAP\n";

if ($LSD1_BINDING eq 'LSD1_BOUND_ENHANCERS')
{
$FILE="FOR_WILCOXON_$GROSEQ_STATUS"; print $FILE "$CHANGE\n";
$FILE="FOR_WILCOXON_$K27_STATUS";    print $FILE "$CHANGE\n";
$FILE="FOR_WILCOXON_$K9_STATUS";     print $FILE "$CHANGE\n";
}
}
close ENHANCER_VALUES_FOR_BOXPLOT;

system("cat ACTIVE_vs_POISED_mES_Enhancers_FOR_BOXPLOT.txt |grep -v LSD1_BOUND > Only_Unbound_For_Boxplot.txt");
system("cat ACTIVE_vs_POISED_mES_Enhancers_FOR_BOXPLOT.txt |grep -v LSD1_UNBOUND > Only_Bound_For_Boxplot.txt");
system("Rscript BOXPLOT.R");
@COLORS=qw(cyan magenta yellow cyan magenta yellow cyan magenta yellow cyan magenta yellow cyan magenta yellow);
for $T (0 .. $#WIL_TYPES) 
	{
	$FILEHANDLE="FOR_WILCOXON_$WIL_TYPES[$T]";
	close $FILEHANDLE;
	print color ("$COLORS[$T]"),"\n\n\n$T\t$WIL_TYPES[$T]\n";
	system("wc -l FOR_WILCOXON_$WIL_TYPES[$T].wil");
	system("Rscript P_VALUE_CALCULATION.R FOR_WILCOXON_$WIL_TYPES[$T].wil; ");
	}



